/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import org.apache.iceberg.parquet.TripleWriter;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.column.ColumnWriter;
import org.apache.parquet.io.api.Binary;

public abstract class AdaptHiveColumnWriter<T>
implements TripleWriter<T> {
    private final ColumnDescriptor desc;
    private final int maxDefinitionLevel;
    private ColumnWriter columnWriter = null;

    public static <T> AdaptHiveColumnWriter<T> newWriter(ColumnDescriptor desc) {
        switch (desc.getPrimitiveType().getPrimitiveTypeName()) {
            case BOOLEAN: {
                return new AdaptHiveColumnWriter<Boolean>(desc){

                    public void write(int rl, Boolean value) {
                        this.writeBoolean(rl, value);
                    }
                };
            }
            case INT32: {
                return new AdaptHiveColumnWriter<Integer>(desc){

                    public void write(int rl, Integer value) {
                        this.writeInteger(rl, value);
                    }
                };
            }
            case INT64: {
                return new AdaptHiveColumnWriter<Long>(desc){

                    public void write(int rl, Long value) {
                        this.writeLong(rl, value);
                    }
                };
            }
            case INT96: {
                return new AdaptHiveColumnWriter<Binary>(desc){

                    public void write(int rl, Binary value) {
                        this.writeBinary(rl, value);
                    }
                };
            }
            case FLOAT: {
                return new AdaptHiveColumnWriter<Float>(desc){

                    public void write(int rl, Float value) {
                        this.writeFloat(rl, value.floatValue());
                    }
                };
            }
            case DOUBLE: {
                return new AdaptHiveColumnWriter<Double>(desc){

                    public void write(int rl, Double value) {
                        this.writeDouble(rl, value);
                    }
                };
            }
            case FIXED_LEN_BYTE_ARRAY: 
            case BINARY: {
                return new AdaptHiveColumnWriter<Binary>(desc){

                    public void write(int rl, Binary value) {
                        this.writeBinary(rl, value);
                    }
                };
            }
        }
        throw new UnsupportedOperationException("Unsupported primitive type: " + desc.getPrimitiveType().getPrimitiveTypeName());
    }

    private AdaptHiveColumnWriter(ColumnDescriptor desc) {
        this.desc = desc;
        this.maxDefinitionLevel = desc.getMaxDefinitionLevel();
    }

    public void setColumnStore(ColumnWriteStore columnStore) {
        this.columnWriter = columnStore.getColumnWriter(this.desc);
    }

    public void writeBoolean(int rl, boolean value) {
        this.columnWriter.write(value, rl, this.maxDefinitionLevel);
    }

    public void writeInteger(int rl, int value) {
        this.columnWriter.write(value, rl, this.maxDefinitionLevel);
    }

    public void writeLong(int rl, long value) {
        this.columnWriter.write(value, rl, this.maxDefinitionLevel);
    }

    public void writeFloat(int rl, float value) {
        this.columnWriter.write(value, rl, this.maxDefinitionLevel);
    }

    public void writeDouble(int rl, double value) {
        this.columnWriter.write(value, rl, this.maxDefinitionLevel);
    }

    public void writeBinary(int rl, Binary value) {
        this.columnWriter.write(value, rl, this.maxDefinitionLevel);
    }

    public void writeNull(int rl, int dl) {
        this.columnWriter.writeNull(rl, dl);
    }
}

