/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kyuubi.jdbc.hive.ClosedOrCancelledException;
import org.apache.kyuubi.jdbc.hive.KyuubiConnection;
import org.apache.kyuubi.jdbc.hive.KyuubiQueryResultSet;
import org.apache.kyuubi.jdbc.hive.KyuubiSQLException;
import org.apache.kyuubi.jdbc.hive.Utils;
import org.apache.kyuubi.jdbc.hive.adapter.SQLStatement;
import org.apache.kyuubi.jdbc.hive.cli.FetchType;
import org.apache.kyuubi.jdbc.hive.cli.RowSet;
import org.apache.kyuubi.jdbc.hive.cli.RowSetFactory;
import org.apache.kyuubi.jdbc.hive.logs.InPlaceUpdateStream;
import org.apache.kyuubi.jdbc.hive.logs.KyuubiLoggable;
import org.apache.kyuubi.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.kyuubi.shade.org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TCancelOperationReq;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TCancelOperationResp;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TCloseOperationReq;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TCloseOperationResp;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TExecuteStatementReq;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TFetchOrientation;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TFetchResultsReq;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TFetchResultsResp;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TGetOperationStatusReq;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TGetOperationStatusResp;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TGetQueryIdReq;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TOperationHandle;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TSessionHandle;
import org.apache.kyuubi.shade.org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KyuubiStatement
implements SQLStatement,
KyuubiLoggable {
    public static final Logger LOG = LoggerFactory.getLogger(KyuubiStatement.class.getName());
    public static final int DEFAULT_FETCH_SIZE = 1000;
    private final KyuubiConnection connection;
    private TCLIService.Iface client;
    private TOperationHandle stmtHandle = null;
    private final TSessionHandle sessHandle;
    Map<String, String> sessConf = new HashMap<String, String>();
    private int fetchSize = 1000;
    private boolean isScrollableResultset = false;
    private boolean isOperationComplete = false;
    private ResultSet resultSet = null;
    private int maxRows = 0;
    private SQLWarning warningChain = null;
    private boolean isClosed = false;
    private boolean isCancelled = false;
    private boolean isQueryClosed = false;
    private boolean isLogBeingGenerated = true;
    private boolean isExecuteStatementFailed = false;
    private int queryTimeout = 0;
    private InPlaceUpdateStream inPlaceUpdateStream = InPlaceUpdateStream.NO_OP;

    public KyuubiStatement(KyuubiConnection connection, TCLIService.Iface client, TSessionHandle sessHandle) {
        this(connection, client, sessHandle, false, 1000);
    }

    public KyuubiStatement(KyuubiConnection connection, TCLIService.Iface client, TSessionHandle sessHandle, int fetchSize) {
        this(connection, client, sessHandle, false, fetchSize);
    }

    public KyuubiStatement(KyuubiConnection connection, TCLIService.Iface client, TSessionHandle sessHandle, boolean isScrollableResultset) {
        this(connection, client, sessHandle, isScrollableResultset, 1000);
    }

    public KyuubiStatement(KyuubiConnection connection, TCLIService.Iface client, TSessionHandle sessHandle, boolean isScrollableResultset, int fetchSize) {
        this.connection = connection;
        this.client = client;
        this.sessHandle = sessHandle;
        this.isScrollableResultset = isScrollableResultset;
        this.fetchSize = fetchSize;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkConnection("cancel");
        if (this.isCancelled) {
            return;
        }
        try {
            if (this.stmtHandle != null) {
                TCancelOperationReq cancelReq = new TCancelOperationReq(this.stmtHandle);
                TCancelOperationResp cancelResp = this.client.CancelOperation(cancelReq);
                Utils.verifySuccessWithInfo(cancelResp.getStatus());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KyuubiSQLException(e.toString(), "08S01", e);
        }
        this.isCancelled = true;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    private void closeStatementIfNeeded() throws SQLException {
        try {
            if (this.stmtHandle != null) {
                TCloseOperationReq closeReq = new TCloseOperationReq(this.stmtHandle);
                TCloseOperationResp closeResp = this.client.CloseOperation(closeReq);
                Utils.verifySuccessWithInfo(closeResp.getStatus());
                this.stmtHandle = null;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KyuubiSQLException(e.toString(), "08S01", e);
        }
    }

    void closeClientOperation() throws SQLException {
        this.closeStatementIfNeeded();
        this.isQueryClosed = true;
        this.isExecuteStatementFailed = false;
        this.stmtHandle = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeClientOperation();
        this.client = null;
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.isClosed = true;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeWithConfOverlay(sql, null);
    }

    private boolean executeWithConfOverlay(String sql, Map<String, String> confOverlay) throws SQLException {
        this.runAsyncOnServer(sql, confOverlay);
        TGetOperationStatusResp status = this.waitForOperationToComplete();
        if (!status.isHasResultSet() && !this.stmtHandle.isHasResultSet()) {
            return false;
        }
        this.resultSet = new KyuubiQueryResultSet.Builder(this).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(this.stmtHandle).setMaxRows(this.maxRows).setFetchSize(this.fetchSize).setScrollable(this.isScrollableResultset).build();
        return true;
    }

    public boolean executeAsync(String sql) throws SQLException {
        this.runAsyncOnServer(sql);
        TGetOperationStatusResp status = this.waitForResultSetStatus();
        if (!status.isHasResultSet()) {
            return false;
        }
        this.resultSet = new KyuubiQueryResultSet.Builder(this).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(this.stmtHandle).setMaxRows(this.maxRows).setFetchSize(this.fetchSize).setScrollable(this.isScrollableResultset).build();
        return true;
    }

    private void runAsyncOnServer(String sql) throws SQLException {
        this.runAsyncOnServer(sql, null);
    }

    private void runAsyncOnServer(String sql, Map<String, String> confOneTime) throws SQLException {
        this.checkConnection("execute");
        this.reInitState();
        TExecuteStatementReq execReq = new TExecuteStatementReq(this.sessHandle, sql);
        execReq.setRunAsync(true);
        if (confOneTime != null) {
            HashMap<String, String> confOverlay = new HashMap<String, String>(this.sessConf);
            confOverlay.putAll(confOneTime);
            execReq.setConfOverlay(confOverlay);
        } else {
            execReq.setConfOverlay(this.sessConf);
        }
        execReq.setQueryTimeout(this.queryTimeout);
        try {
            TExecuteStatementResp execResp = this.client.ExecuteStatement(execReq);
            Utils.verifySuccessWithInfo(execResp.getStatus());
            this.stmtHandle = execResp.getOperationHandle();
            this.isExecuteStatementFailed = false;
        }
        catch (SQLException eS) {
            this.isExecuteStatementFailed = true;
            this.isLogBeingGenerated = false;
            throw eS;
        }
        catch (Exception ex) {
            this.isExecuteStatementFailed = true;
            this.isLogBeingGenerated = false;
            throw new KyuubiSQLException(ex.toString(), "08S01", ex);
        }
    }

    private TGetOperationStatusResp waitForResultSetStatus() throws SQLException {
        TGetOperationStatusReq statusReq = new TGetOperationStatusReq(this.stmtHandle);
        TGetOperationStatusResp statusResp = null;
        while (statusResp == null || !statusResp.isSetHasResultSet()) {
            try {
                statusResp = this.client.GetOperationStatus(statusReq);
            }
            catch (TException e) {
                this.isLogBeingGenerated = false;
                throw new KyuubiSQLException(e.toString(), "08S01", e);
            }
        }
        return statusResp;
    }

    TGetOperationStatusResp waitForOperationToComplete() throws SQLException {
        TGetOperationStatusReq statusReq = new TGetOperationStatusReq(this.stmtHandle);
        boolean shouldGetProgressUpdate = this.inPlaceUpdateStream != InPlaceUpdateStream.NO_OP;
        statusReq.setGetProgressUpdate(shouldGetProgressUpdate);
        if (!shouldGetProgressUpdate) {
            this.inPlaceUpdateStream.getEventNotifier().progressBarCompleted();
        }
        TGetOperationStatusResp statusResp = null;
        while (!this.isOperationComplete) {
            try {
                statusResp = this.client.GetOperationStatus(statusReq);
                this.inPlaceUpdateStream.update(statusResp.getProgressUpdateResponse());
                Utils.verifySuccessWithInfo(statusResp.getStatus());
                if (!statusResp.isSetOperationState()) continue;
                switch (statusResp.getOperationState()) {
                    case CLOSED_STATE: 
                    case FINISHED_STATE: {
                        this.isOperationComplete = true;
                        this.isLogBeingGenerated = false;
                        break;
                    }
                    case CANCELED_STATE: {
                        String errMsg = statusResp.getErrorMessage();
                        if (errMsg != null && !errMsg.isEmpty()) {
                            throw new KyuubiSQLException("Query was cancelled. " + errMsg, "01000");
                        }
                        throw new KyuubiSQLException("Query was cancelled", "01000");
                    }
                    case TIMEDOUT_STATE: {
                        throw new SQLTimeoutException("Query timed out after " + this.queryTimeout + " seconds");
                    }
                    case ERROR_STATE: {
                        throw new KyuubiSQLException(statusResp.getErrorMessage(), statusResp.getSqlState(), statusResp.getErrorCode());
                    }
                    case UKNOWN_STATE: {
                        throw new KyuubiSQLException("Unknown query", "HY000");
                    }
                }
            }
            catch (SQLException e) {
                this.isLogBeingGenerated = false;
                throw e;
            }
            catch (Exception e) {
                this.isLogBeingGenerated = false;
                throw new KyuubiSQLException(e.toString(), "08S01", e);
            }
        }
        this.inPlaceUpdateStream.getEventNotifier().progressBarCompleted();
        return statusResp;
    }

    private void checkConnection(String action) throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Can't " + action + " after statement has been closed");
        }
    }

    private void reInitState() throws SQLException {
        this.closeStatementIfNeeded();
        this.isCancelled = false;
        this.isQueryClosed = false;
        this.isLogBeingGenerated = true;
        this.isExecuteStatementFailed = false;
        this.isOperationComplete = false;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw new KyuubiSQLException("The query did not generate a result set!");
        }
        return this.resultSet;
    }

    public ResultSet executeScala(String code) throws SQLException {
        if (!this.executeWithConfOverlay(code, Collections.singletonMap("kyuubi.operation.language", "SCALA"))) {
            throw new KyuubiSQLException("The query did not generate a result set!");
        }
        return this.resultSet;
    }

    public void executeSetCurrentCatalog(String sql, String catalog) throws SQLException {
        if (this.executeWithConfOverlay(sql, Collections.singletonMap("kyuubi.operation.set.current.catalog", catalog))) {
            this.resultSet.close();
        }
    }

    public ResultSet executeGetCurrentCatalog(String sql) throws SQLException {
        if (!this.executeWithConfOverlay(sql, Collections.singletonMap("kyuubi.operation.get.current.catalog", ""))) {
            throw new KyuubiSQLException("The query did not generate a result set!");
        }
        return this.resultSet;
    }

    public void executeSetCurrentDatabase(String sql, String database) throws SQLException {
        if (this.executeWithConfOverlay(sql, Collections.singletonMap("kyuubi.operation.set.current.database", database))) {
            this.resultSet.close();
        }
    }

    public ResultSet executeGetCurrentDatabase(String sql) throws SQLException {
        if (!this.executeWithConfOverlay(sql, Collections.singletonMap("kyuubi.operation.get.current.database", ""))) {
            throw new KyuubiSQLException("The query did not generate a result set!");
        }
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        return 0;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkConnection("getConnection");
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkConnection("getFetchDirection");
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkConnection("getFetchSize");
        return this.fetchSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkConnection("getMaxRows");
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkConnection("getQueryTimeout");
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkConnection("getResultSet");
        return this.resultSet;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkConnection("getResultSetType");
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkConnection("getUpdateCount");
        this.waitForOperationToComplete();
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkConnection("getWarnings");
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkConnection("setFetchDirection");
        if (direction != 1000) {
            throw new KyuubiSQLException("Not supported direction " + direction);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkConnection("setFetchSize");
        if (rows > 0) {
            this.fetchSize = rows;
        } else if (rows == 0) {
            this.fetchSize = 1000;
        } else {
            throw new KyuubiSQLException("Fetch size must be greater or equal to 0");
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkConnection("setMaxRows");
        if (max < 0) {
            throw new KyuubiSQLException("max must be >= 0");
        }
        this.maxRows = max;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new KyuubiSQLException("Cannot unwrap to " + iface);
    }

    @Override
    public boolean hasMoreLogs() {
        return this.isLogBeingGenerated;
    }

    @Override
    public List<String> getExecLog() throws SQLException, ClosedOrCancelledException {
        return this.getQueryLog(true, this.fetchSize);
    }

    public List<String> getQueryLog(boolean incremental, int fetchSize) throws SQLException, ClosedOrCancelledException {
        this.checkConnection("getQueryLog");
        if (this.isCancelled) {
            throw new ClosedOrCancelledException("Method getQueryLog() failed. The statement has been closed or cancelled.");
        }
        ArrayList<String> logs = new ArrayList<String>();
        TFetchResultsResp tFetchResultsResp = null;
        try {
            if (this.stmtHandle == null) {
                if (this.isQueryClosed) {
                    throw new ClosedOrCancelledException("Method getQueryLog() failed. The statement has been closed or cancelled.");
                }
                return logs;
            }
            TFetchResultsReq tFetchResultsReq = new TFetchResultsReq(this.stmtHandle, this.getFetchOrientation(incremental), fetchSize);
            tFetchResultsReq.setFetchType(FetchType.LOG.toTFetchType());
            tFetchResultsResp = this.client.FetchResults(tFetchResultsReq);
            Utils.verifySuccessWithInfo(tFetchResultsResp.getStatus());
        }
        catch (SQLException e) {
            throw e;
        }
        catch (TException e) {
            throw new KyuubiSQLException("Error when getting query log: " + e, e);
        }
        catch (Exception e) {
            throw new KyuubiSQLException("Error when getting query log: " + e, e);
        }
        try {
            RowSet rowSet = RowSetFactory.create(tFetchResultsResp.getResults(), this.connection.getProtocol());
            for (Object[] row : rowSet) {
                logs.add(String.valueOf(row[0]));
            }
        }
        catch (TException e) {
            throw new KyuubiSQLException("Error building result set for query log: " + e, e);
        }
        return logs;
    }

    private TFetchOrientation getFetchOrientation(boolean incremental) {
        if (incremental) {
            return TFetchOrientation.FETCH_NEXT;
        }
        return TFetchOrientation.FETCH_FIRST;
    }

    public String getYarnATSGuid() {
        if (this.stmtHandle != null) {
            String guid64 = Base64.getUrlEncoder().encodeToString(this.stmtHandle.getOperationId().getGuid()).trim();
            return guid64;
        }
        return null;
    }

    @VisibleForTesting
    public String getQueryId() throws SQLException {
        if (this.stmtHandle == null) {
            return null;
        }
        try {
            String queryId = this.client.GetQueryId(new TGetQueryIdReq(this.stmtHandle)).getQueryId();
            return StringUtils.isBlank(queryId) ? null : queryId;
        }
        catch (TException e) {
            throw new KyuubiSQLException(e);
        }
    }

    public void setInPlaceUpdateStream(InPlaceUpdateStream stream) {
        this.inPlaceUpdateStream = stream;
    }
}

