/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.utils;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.io.network.netty.InboundChannelHandlerFactory;
import org.apache.flink.runtime.io.network.netty.SSLHandlerFactory;
import org.apache.flink.runtime.rest.FlinkHttpObjectAggregator;
import org.apache.flink.runtime.rest.handler.router.Router;
import org.apache.flink.runtime.rest.handler.router.RouterHandler;
import org.apache.flink.runtime.webmonitor.HttpRequestHandler;
import org.apache.flink.runtime.webmonitor.PipelineErrorHandler;
import org.apache.flink.shaded.netty4.io.netty.bootstrap.ServerBootstrap;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFuture;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInitializer;
import org.apache.flink.shaded.netty4.io.netty.channel.EventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.socket.SocketChannel;
import org.apache.flink.shaded.netty4.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpServerCodec;
import org.apache.flink.shaded.netty4.io.netty.handler.stream.ChunkedWriteHandler;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public class WebFrontendBootstrap {
    private final Router router;
    private final Logger log;
    private final File uploadDir;
    private final ServerBootstrap bootstrap;
    private final Channel serverChannel;
    private final String restAddress;
    private final int maxContentLength;
    private final Map<String, String> responseHeaders;
    @VisibleForTesting
    List<InboundChannelHandlerFactory> inboundChannelHandlerFactories;

    public WebFrontendBootstrap(Router router, Logger log, File directory, final @Nullable SSLHandlerFactory serverSSLFactory, String configuredAddress, int configuredPort, final Configuration config) throws InterruptedException, UnknownHostException {
        this.router = (Router)Preconditions.checkNotNull((Object)router);
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
        this.uploadDir = directory;
        this.maxContentLength = (Integer)config.get(RestOptions.SERVER_MAX_CONTENT_LENGTH);
        this.responseHeaders = new HashMap<String, String>();
        this.inboundChannelHandlerFactories = new ArrayList<InboundChannelHandlerFactory>();
        ServiceLoader<InboundChannelHandlerFactory> loader = ServiceLoader.load(InboundChannelHandlerFactory.class);
        Iterator<InboundChannelHandlerFactory> factories = loader.iterator();
        while (factories.hasNext()) {
            try {
                InboundChannelHandlerFactory factory = factories.next();
                if (factory == null) continue;
                this.inboundChannelHandlerFactories.add(factory);
                log.info("Loaded channel inbound factory: {}", (Object)factory);
            }
            catch (Throwable e) {
                log.error("Could not load channel inbound factory.", e);
                throw e;
            }
        }
        this.inboundChannelHandlerFactories.sort(Comparator.comparingInt(InboundChannelHandlerFactory::priority).reversed());
        ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws ConfigurationException {
                RouterHandler handler = new RouterHandler(WebFrontendBootstrap.this.router, WebFrontendBootstrap.this.responseHeaders);
                if (serverSSLFactory != null) {
                    ch.pipeline().addLast("ssl", (ChannelHandler)serverSSLFactory.createNettySSLHandler(ch.alloc()));
                }
                ch.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new HttpRequestHandler(WebFrontendBootstrap.this.uploadDir)}).addLast(new ChannelHandler[]{new FlinkHttpObjectAggregator(WebFrontendBootstrap.this.maxContentLength, WebFrontendBootstrap.this.responseHeaders)});
                for (InboundChannelHandlerFactory factory : WebFrontendBootstrap.this.inboundChannelHandlerFactories) {
                    Optional channelHandler = factory.createHandler(config, WebFrontendBootstrap.this.responseHeaders);
                    if (!channelHandler.isPresent()) continue;
                    ch.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)channelHandler.get()});
                }
                ch.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()}).addLast(handler.getName(), (ChannelHandler)handler).addLast(new ChannelHandler[]{new PipelineErrorHandler(WebFrontendBootstrap.this.log)});
            }
        };
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        this.bootstrap = new ServerBootstrap();
        ((ServerBootstrap)this.bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)initializer);
        ChannelFuture ch = configuredAddress == null ? this.bootstrap.bind(configuredPort) : this.bootstrap.bind(configuredAddress, configuredPort);
        this.serverChannel = ch.sync().channel();
        InetSocketAddress bindAddress = (InetSocketAddress)this.serverChannel.localAddress();
        InetAddress inetAddress = bindAddress.getAddress();
        String address = inetAddress.isAnyLocalAddress() ? (String)config.get(JobManagerOptions.ADDRESS, (Object)InetAddress.getLocalHost().getHostName()) : inetAddress.getHostAddress();
        int port = bindAddress.getPort();
        this.log.info("Web frontend listening at {}:{}", (Object)address, (Object)port);
        String protocol = serverSSLFactory != null ? "https://" : "http://";
        this.restAddress = protocol + address + ':' + port;
    }

    public ServerBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public int getServerPort() {
        Channel server = this.serverChannel;
        if (server != null) {
            try {
                return ((InetSocketAddress)server.localAddress()).getPort();
            }
            catch (Exception e) {
                this.log.error("Cannot access local server port", (Throwable)e);
            }
        }
        return -1;
    }

    public String getRestAddress() {
        return this.restAddress;
    }

    public void shutdown() {
        if (this.serverChannel != null) {
            this.serverChannel.close().awaitUninterruptibly();
        }
        if (this.bootstrap != null) {
            if (this.bootstrap.config().group() != null) {
                this.bootstrap.config().group().shutdownGracefully();
            }
            if (this.bootstrap.config().childGroup() != null) {
                this.bootstrap.config().childGroup().shutdownGracefully();
            }
        }
    }
}

