/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.StateField;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.BlockableOperation;
import org.apache.amoro.config.OptimizingConfig;
import org.apache.amoro.config.TableConfiguration;
import org.apache.amoro.optimizing.OptimizingType;
import org.apache.amoro.optimizing.plan.AbstractOptimizingEvaluator;
import org.apache.amoro.server.metrics.MetricRegistry;
import org.apache.amoro.server.optimizing.OptimizingProcess;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.server.optimizing.TaskRuntime;
import org.apache.amoro.server.persistence.StatedPersistentBase;
import org.apache.amoro.server.persistence.TableRuntimeMeta;
import org.apache.amoro.server.persistence.mapper.OptimizingMapper;
import org.apache.amoro.server.persistence.mapper.TableBlockerMapper;
import org.apache.amoro.server.persistence.mapper.TableMetaMapper;
import org.apache.amoro.server.table.TableConfigurations;
import org.apache.amoro.server.table.TableOptimizingMetrics;
import org.apache.amoro.server.table.TableOrphanFilesCleaningMetrics;
import org.apache.amoro.server.table.TableRuntimeHandler;
import org.apache.amoro.server.table.TableSummaryMetrics;
import org.apache.amoro.server.table.blocker.TableBlocker;
import org.apache.amoro.server.utils.IcebergTableUtil;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.table.BaseTable;
import org.apache.amoro.table.ChangeTable;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRuntime
extends StatedPersistentBase {
    private static final Logger LOG = LoggerFactory.getLogger(TableRuntime.class);
    private final Lock tableLock = new ReentrantLock();
    private final TableRuntimeHandler tableHandler;
    private final ServerTableIdentifier tableIdentifier;
    private final List<TaskRuntime.TaskQuota> taskQuotas = new CopyOnWriteArrayList<TaskRuntime.TaskQuota>();
    @StateField
    private volatile long currentSnapshotId = -1L;
    @StateField
    private volatile long lastOptimizedSnapshotId = -1L;
    @StateField
    private volatile long lastOptimizedChangeSnapshotId = -1L;
    @StateField
    private volatile long currentChangeSnapshotId = -1L;
    @StateField
    private volatile OptimizingStatus optimizingStatus = OptimizingStatus.IDLE;
    @StateField
    private volatile long currentStatusStartTime = System.currentTimeMillis();
    @StateField
    private volatile long lastMajorOptimizingTime;
    @StateField
    private volatile long lastFullOptimizingTime;
    @StateField
    private volatile long lastMinorOptimizingTime;
    @StateField
    private volatile String optimizerGroup;
    @StateField
    private volatile OptimizingProcess optimizingProcess;
    @StateField
    private volatile TableConfiguration tableConfiguration;
    @StateField
    private volatile long processId;
    @StateField
    private volatile AbstractOptimizingEvaluator.PendingInput pendingInput;
    @StateField
    private volatile AbstractOptimizingEvaluator.PendingInput tableSummary;
    private volatile long lastPlanTime;
    private final TableOptimizingMetrics optimizingMetrics;
    private final TableOrphanFilesCleaningMetrics orphanFilesCleaningMetrics;
    private final TableSummaryMetrics tableSummaryMetrics;
    private long targetSnapshotId;
    private long targetChangeSnapshotId;
    private Map<String, Long> fromSequence;
    private Map<String, Long> toSequence;
    private OptimizingType optimizingType;

    public TableRuntime(ServerTableIdentifier tableIdentifier, TableRuntimeHandler tableHandler, Map<String, String> properties) {
        Preconditions.checkNotNull((Object)tableIdentifier, (Object)"ServerTableIdentifier must not be null.");
        Preconditions.checkNotNull((Object)tableHandler, (Object)"TableRuntimeHandler must not be null.");
        this.tableHandler = tableHandler;
        this.tableIdentifier = tableIdentifier;
        this.tableConfiguration = TableConfigurations.parseTableConfig(properties);
        this.optimizerGroup = this.tableConfiguration.getOptimizingConfig().getOptimizerGroup();
        this.persistTableRuntime();
        this.optimizingMetrics = new TableOptimizingMetrics(tableIdentifier);
        this.orphanFilesCleaningMetrics = new TableOrphanFilesCleaningMetrics(tableIdentifier);
        this.tableSummaryMetrics = new TableSummaryMetrics(tableIdentifier);
    }

    public TableRuntime(TableRuntimeMeta tableRuntimeMeta, TableRuntimeHandler tableHandler) {
        Preconditions.checkNotNull((Object)tableRuntimeMeta, (Object)"TableRuntimeMeta must not be null.");
        Preconditions.checkNotNull((Object)tableHandler, (Object)"TableRuntimeHandler must not be null.");
        this.tableHandler = tableHandler;
        this.tableIdentifier = ServerTableIdentifier.of((Long)tableRuntimeMeta.getTableId(), (String)tableRuntimeMeta.getCatalogName(), (String)tableRuntimeMeta.getDbName(), (String)tableRuntimeMeta.getTableName(), (TableFormat)tableRuntimeMeta.getFormat());
        this.currentSnapshotId = tableRuntimeMeta.getCurrentSnapshotId();
        this.lastOptimizedSnapshotId = tableRuntimeMeta.getLastOptimizedSnapshotId();
        this.lastOptimizedChangeSnapshotId = tableRuntimeMeta.getLastOptimizedChangeSnapshotId();
        this.currentChangeSnapshotId = tableRuntimeMeta.getCurrentChangeSnapshotId();
        this.currentStatusStartTime = tableRuntimeMeta.getCurrentStatusStartTime();
        this.lastMinorOptimizingTime = tableRuntimeMeta.getLastMinorOptimizingTime();
        this.lastMajorOptimizingTime = tableRuntimeMeta.getLastMajorOptimizingTime();
        this.lastFullOptimizingTime = tableRuntimeMeta.getLastFullOptimizingTime();
        this.optimizerGroup = tableRuntimeMeta.getOptimizerGroup();
        this.tableConfiguration = tableRuntimeMeta.getTableConfig();
        this.processId = tableRuntimeMeta.getOptimizingProcessId();
        this.optimizingStatus = tableRuntimeMeta.getTableStatus() == OptimizingStatus.PLANNING ? OptimizingStatus.PENDING : tableRuntimeMeta.getTableStatus();
        this.pendingInput = tableRuntimeMeta.getPendingInput();
        this.tableSummary = tableRuntimeMeta.getTableSummary();
        this.optimizingMetrics = new TableOptimizingMetrics(this.tableIdentifier);
        this.optimizingMetrics.statusChanged(this.optimizingStatus, this.currentStatusStartTime);
        this.optimizingMetrics.lastOptimizingTime(OptimizingType.MINOR, this.lastMinorOptimizingTime);
        this.optimizingMetrics.lastOptimizingTime(OptimizingType.MAJOR, this.lastMajorOptimizingTime);
        this.optimizingMetrics.lastOptimizingTime(OptimizingType.FULL, this.lastFullOptimizingTime);
        this.orphanFilesCleaningMetrics = new TableOrphanFilesCleaningMetrics(this.tableIdentifier);
        this.tableSummaryMetrics = new TableSummaryMetrics(this.tableIdentifier);
        this.tableSummaryMetrics.refresh(this.tableSummary);
        this.targetSnapshotId = tableRuntimeMeta.getTargetSnapshotId();
        this.targetChangeSnapshotId = tableRuntimeMeta.getTargetChangeSnapshotId();
        this.fromSequence = tableRuntimeMeta.getFromSequence();
        this.toSequence = tableRuntimeMeta.getToSequence();
        this.optimizingType = tableRuntimeMeta.getOptimizingType();
    }

    public void recover(OptimizingProcess optimizingProcess) {
        if (!this.optimizingStatus.isProcessing() || !Objects.equals(optimizingProcess.getProcessId(), this.processId)) {
            throw new IllegalStateException("Table runtime and processing are not matched!");
        }
        this.optimizingProcess = optimizingProcess;
    }

    public void registerMetric(MetricRegistry metricRegistry) {
        this.optimizingMetrics.register(metricRegistry);
        this.orphanFilesCleaningMetrics.register(metricRegistry);
        this.tableSummaryMetrics.register(metricRegistry);
    }

    public void dispose() {
        this.tableSummaryMetrics.unregister();
        this.orphanFilesCleaningMetrics.unregister();
        this.optimizingMetrics.unregister();
        this.tableLock.lock();
        try {
            this.doAsTransaction(() -> Optional.ofNullable(this.optimizingProcess).ifPresent(OptimizingProcess::close), () -> this.doAs(TableMetaMapper.class, mapper -> mapper.deleteOptimizingRuntime(this.tableIdentifier.getId())));
        }
        finally {
            this.tableLock.unlock();
        }
    }

    public void beginPlanning() {
        this.invokeConsistency(() -> {
            OptimizingStatus originalStatus = this.optimizingStatus;
            this.updateOptimizingStatus(OptimizingStatus.PLANNING);
            this.persistUpdatingRuntime();
            this.tableHandler.handleTableChanged(this, originalStatus);
        });
    }

    public void planFailed() {
        try {
            this.invokeConsistency(() -> {
                OptimizingStatus originalStatus = this.optimizingStatus;
                this.updateOptimizingStatus(OptimizingStatus.PENDING);
                this.persistUpdatingRuntime();
                this.tableHandler.handleTableChanged(this, originalStatus);
            });
        }
        catch (Exception e) {
            OptimizingStatus originalStatus = this.optimizingStatus;
            this.updateOptimizingStatus(OptimizingStatus.PENDING);
            LOG.warn("Persistent database failed, only the optimizing state in the memory was changed.", (Throwable)e);
            this.tableHandler.handleTableChanged(this, originalStatus);
        }
    }

    public void beginProcess(OptimizingProcess optimizingProcess) {
        this.invokeConsistency(() -> {
            OptimizingStatus originalStatus = this.optimizingStatus;
            this.optimizingProcess = optimizingProcess;
            this.processId = optimizingProcess.getProcessId();
            this.updateOptimizingStatus(OptimizingStatus.ofOptimizingType(optimizingProcess.getOptimizingType()));
            this.pendingInput = null;
            this.persistUpdatingRuntime();
            this.tableHandler.handleTableChanged(this, originalStatus);
        });
    }

    public void beginCommitting() {
        this.invokeConsistency(() -> {
            OptimizingStatus originalStatus = this.optimizingStatus;
            this.updateOptimizingStatus(OptimizingStatus.COMMITTING);
            this.persistUpdatingRuntime();
            this.tableHandler.handleTableChanged(this, originalStatus);
        });
    }

    public void setPendingInput(AbstractOptimizingEvaluator.PendingInput pendingInput) {
        this.invokeConsistency(() -> {
            this.pendingInput = pendingInput;
            if (this.optimizingStatus == OptimizingStatus.IDLE) {
                this.updateOptimizingStatus(OptimizingStatus.PENDING);
                this.persistUpdatingRuntime();
                LOG.info("{} status changed from idle to pending with pendingInput {}", (Object)this.tableIdentifier, (Object)pendingInput);
                this.tableHandler.handleTableChanged(this, OptimizingStatus.IDLE);
            }
        });
    }

    public TableRuntime refresh(AmoroTable<?> table) {
        return this.invokeConsistency(() -> {
            TableConfiguration configuration = this.tableConfiguration;
            boolean configChanged = this.updateConfigInternal(table.properties());
            if (this.refreshSnapshots(table) || configChanged) {
                this.persistUpdatingRuntime();
            }
            if (configChanged) {
                this.tableHandler.handleTableChanged(this, configuration);
            }
            return this;
        });
    }

    public void setTableSummary(AbstractOptimizingEvaluator.PendingInput tableSummary) {
        this.invokeConsistency(() -> {
            this.tableSummary = tableSummary;
            this.tableSummaryMetrics.refresh(tableSummary);
            this.persistUpdatingRuntime();
        });
    }

    public void completeEmptyProcess() {
        this.invokeConsistency(() -> {
            this.pendingInput = null;
            if (this.optimizingStatus == OptimizingStatus.PLANNING || this.optimizingStatus == OptimizingStatus.PENDING) {
                this.updateOptimizingStatus(OptimizingStatus.IDLE);
                this.lastOptimizedSnapshotId = this.currentSnapshotId;
                this.lastOptimizedChangeSnapshotId = this.currentChangeSnapshotId;
                this.persistUpdatingRuntime();
                this.tableHandler.handleTableChanged(this, this.optimizingStatus);
            }
        });
    }

    public void optimizingNotNecessary() {
        this.invokeConsistency(() -> {
            if (this.optimizingStatus == OptimizingStatus.IDLE) {
                this.lastOptimizedSnapshotId = this.currentSnapshotId;
                this.lastOptimizedChangeSnapshotId = this.currentChangeSnapshotId;
                this.persistUpdatingRuntime();
            }
        });
    }

    public void resetTaskQuotas(long startTimeMills) {
        this.tableLock.lock();
        try {
            this.taskQuotas.clear();
            this.taskQuotas.addAll(this.getAs(OptimizingMapper.class, mapper -> mapper.selectTaskQuotasByTime(this.tableIdentifier.getId(), startTimeMills)));
        }
        finally {
            this.tableLock.unlock();
        }
    }

    public void completeProcess(boolean success) {
        this.invokeConsistency(() -> {
            OptimizingStatus originalStatus = this.optimizingStatus;
            OptimizingType processType = this.optimizingProcess.getOptimizingType();
            if (success) {
                this.lastOptimizedSnapshotId = this.optimizingProcess.getTargetSnapshotId();
                this.lastOptimizedChangeSnapshotId = this.optimizingProcess.getTargetChangeSnapshotId();
                if (processType == OptimizingType.MINOR) {
                    this.lastMinorOptimizingTime = this.optimizingProcess.getPlanTime();
                } else if (processType == OptimizingType.MAJOR) {
                    this.lastMajorOptimizingTime = this.optimizingProcess.getPlanTime();
                } else if (processType == OptimizingType.FULL) {
                    this.lastFullOptimizingTime = this.optimizingProcess.getPlanTime();
                }
            }
            this.optimizingMetrics.processComplete(processType, success, this.optimizingProcess.getPlanTime());
            this.updateOptimizingStatus(OptimizingStatus.IDLE);
            this.optimizingProcess = null;
            this.persistUpdatingRuntime();
            this.tableHandler.handleTableChanged(this, originalStatus);
        });
    }

    private void updateOptimizingStatus(OptimizingStatus status) {
        this.optimizingStatus = status;
        this.currentStatusStartTime = System.currentTimeMillis();
        this.optimizingMetrics.statusChanged(status, this.currentStatusStartTime);
    }

    private boolean refreshSnapshots(AmoroTable<?> amoroTable) {
        MixedTable table = (MixedTable)amoroTable.originalTable();
        this.tableSummaryMetrics.refreshSnapshots(table);
        long lastSnapshotId = this.currentSnapshotId;
        if (table.isKeyedTable()) {
            long changeSnapshotId = this.currentChangeSnapshotId;
            ChangeTable changeTable = table.asKeyedTable().changeTable();
            BaseTable baseTable = table.asKeyedTable().baseTable();
            this.currentChangeSnapshotId = this.doRefreshSnapshots((UnkeyedTable)changeTable);
            this.currentSnapshotId = this.doRefreshSnapshots((UnkeyedTable)baseTable);
            if (this.currentSnapshotId != lastSnapshotId || this.currentChangeSnapshotId != changeSnapshotId) {
                LOG.info("Refreshing table {} with base snapshot id {} and change snapshot id {}", new Object[]{this.tableIdentifier, this.currentSnapshotId, this.currentChangeSnapshotId});
                return true;
            }
        } else {
            this.currentSnapshotId = this.doRefreshSnapshots((UnkeyedTable)table);
            if (this.currentSnapshotId != lastSnapshotId) {
                LOG.info("Refreshing table {} with base snapshot id {}", (Object)this.tableIdentifier, (Object)this.currentSnapshotId);
                return true;
            }
        }
        return false;
    }

    private long doRefreshSnapshots(UnkeyedTable table) {
        long currentSnapshotId = -1L;
        Snapshot currentSnapshot = IcebergTableUtil.getSnapshot((Table)table, false);
        if (currentSnapshot != null) {
            currentSnapshotId = currentSnapshot.snapshotId();
        }
        this.optimizingMetrics.nonMaintainedSnapshotTime(currentSnapshot);
        this.optimizingMetrics.lastOptimizingSnapshotTime(IcebergTableUtil.findLatestOptimizingSnapshot((Table)table).orElse(null));
        return currentSnapshotId;
    }

    public AbstractOptimizingEvaluator.PendingInput getPendingInput() {
        return this.pendingInput;
    }

    public AbstractOptimizingEvaluator.PendingInput getTableSummary() {
        return this.tableSummary;
    }

    private boolean updateConfigInternal(Map<String, String> properties) {
        TableConfiguration newTableConfig = TableConfigurations.parseTableConfig(properties);
        if (this.tableConfiguration.equals((Object)newTableConfig)) {
            return false;
        }
        if (!Objects.equals(this.optimizerGroup, newTableConfig.getOptimizingConfig().getOptimizerGroup())) {
            if (this.optimizingProcess != null) {
                this.optimizingProcess.close();
            }
            this.optimizerGroup = newTableConfig.getOptimizingConfig().getOptimizerGroup();
        }
        this.tableConfiguration = newTableConfig;
        return true;
    }

    public void addTaskQuota(TaskRuntime.TaskQuota taskQuota) {
        this.doAsIgnoreError(OptimizingMapper.class, mapper -> mapper.insertTaskQuota(taskQuota));
        this.taskQuotas.add(taskQuota);
        long validTime = System.currentTimeMillis() - 3600000L;
        this.taskQuotas.removeIf(task -> task.checkExpired(validTime));
    }

    private void persistTableRuntime() {
        this.doAs(TableMetaMapper.class, mapper -> mapper.insertTableRuntime(this));
    }

    private void persistUpdatingRuntime() {
        this.doAs(TableMetaMapper.class, mapper -> mapper.updateTableRuntime(this));
    }

    public OptimizingProcess getOptimizingProcess() {
        return this.optimizingProcess;
    }

    public long getCurrentSnapshotId() {
        return this.currentSnapshotId;
    }

    public void updateCurrentChangeSnapshotId(long snapshotId) {
        this.currentChangeSnapshotId = snapshotId;
    }

    public ServerTableIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public TableFormat getFormat() {
        return this.tableIdentifier.getFormat();
    }

    public OptimizingStatus getOptimizingStatus() {
        return this.optimizingStatus;
    }

    public long getLastOptimizedSnapshotId() {
        return this.lastOptimizedSnapshotId;
    }

    public long getLastOptimizedChangeSnapshotId() {
        return this.lastOptimizedChangeSnapshotId;
    }

    public long getCurrentChangeSnapshotId() {
        return this.currentChangeSnapshotId;
    }

    public long getCurrentStatusStartTime() {
        return this.currentStatusStartTime;
    }

    public long getLastMajorOptimizingTime() {
        return this.lastMajorOptimizingTime;
    }

    public long getLastFullOptimizingTime() {
        return this.lastFullOptimizingTime;
    }

    public long getLastMinorOptimizingTime() {
        return this.lastMinorOptimizingTime;
    }

    public TableConfiguration getTableConfiguration() {
        return this.tableConfiguration;
    }

    public OptimizingConfig getOptimizingConfig() {
        return this.tableConfiguration.getOptimizingConfig();
    }

    public boolean isOptimizingEnabled() {
        return this.tableConfiguration.getOptimizingConfig().isEnabled();
    }

    public Double getTargetQuota() {
        return this.tableConfiguration.getOptimizingConfig().getTargetQuota();
    }

    public String getOptimizerGroup() {
        return this.optimizerGroup;
    }

    public TableOrphanFilesCleaningMetrics getOrphanFilesCleaningMetrics() {
        return this.orphanFilesCleaningMetrics;
    }

    public void setCurrentChangeSnapshotId(long currentChangeSnapshotId) {
        this.currentChangeSnapshotId = currentChangeSnapshotId;
    }

    public int getMaxExecuteRetryCount() {
        return this.tableConfiguration.getOptimizingConfig().getMaxExecuteRetryCount();
    }

    public long getNewestProcessId() {
        return this.processId;
    }

    public long getLastPlanTime() {
        return this.lastPlanTime;
    }

    public void setLastPlanTime(long lastPlanTime) {
        this.lastPlanTime = lastPlanTime;
    }

    public long getTargetSnapshotId() {
        return this.targetSnapshotId;
    }

    public void setTargetSnapshotId(long targetSnapshotId) {
        this.targetSnapshotId = targetSnapshotId;
    }

    public long getTargetChangeSnapshotId() {
        return this.targetChangeSnapshotId;
    }

    public void setTargetChangeSnapshotId(long targetChangeSnapshotId) {
        this.targetChangeSnapshotId = targetChangeSnapshotId;
    }

    public Map<String, Long> getFromSequence() {
        return this.fromSequence;
    }

    public void setFromSequence(Map<String, Long> fromSequence) {
        this.fromSequence = fromSequence;
    }

    public Map<String, Long> getToSequence() {
        return this.toSequence;
    }

    public void setToSequence(Map<String, Long> toSequence) {
        this.toSequence = toSequence;
    }

    public long getProcessId() {
        return this.processId;
    }

    public OptimizingType getOptimizingType() {
        return this.optimizingType;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableIdentifier", (Object)this.tableIdentifier).add("currentSnapshotId", this.currentSnapshotId).add("lastOptimizedSnapshotId", this.lastOptimizedSnapshotId).add("lastOptimizedChangeSnapshotId", this.lastOptimizedChangeSnapshotId).add("optimizingStatus", (Object)this.optimizingStatus).add("currentStatusStartTime", this.currentStatusStartTime).add("lastMajorOptimizingTime", this.lastMajorOptimizingTime).add("lastFullOptimizingTime", this.lastFullOptimizingTime).add("lastMinorOptimizingTime", this.lastMinorOptimizingTime).add("tableConfiguration", (Object)this.tableConfiguration).add("targetSnapshotId", this.targetSnapshotId).add("targetChangeSnapshotId", this.targetChangeSnapshotId).add("fromSequence", this.fromSequence).add("toSequence", this.toSequence).toString();
    }

    public long getQuotaTime() {
        long calculatingEndTime = System.currentTimeMillis();
        long calculatingStartTime = calculatingEndTime - 3600000L;
        this.taskQuotas.removeIf(task -> task.checkExpired(calculatingStartTime));
        long finishedTaskQuotaTime = this.taskQuotas.stream().mapToLong(taskQuota -> taskQuota.getQuotaTime(calculatingStartTime)).sum();
        return this.optimizingProcess == null ? finishedTaskQuotaTime : finishedTaskQuotaTime + this.optimizingProcess.getRunningQuotaTime(calculatingStartTime, calculatingEndTime);
    }

    public double calculateQuotaOccupy() {
        return new BigDecimal((double)this.getQuotaTime() / 3600000.0 / this.tableConfiguration.getOptimizingConfig().getTargetQuota()).setScale(4, RoundingMode.HALF_UP).doubleValue();
    }

    public boolean isBlocked(BlockableOperation operation) {
        List tableBlockers = this.getAs(TableBlockerMapper.class, mapper -> mapper.selectBlockers(this.tableIdentifier.getCatalog(), this.tableIdentifier.getDatabase(), this.tableIdentifier.getTableName(), System.currentTimeMillis()));
        return TableBlocker.conflict(operation, (List<TableBlocker>)tableBlockers);
    }

    @Override
    protected void invokeConsistency(Runnable runnable) {
        this.tableLock.lock();
        try {
            super.invokeConsistency(runnable);
        }
        finally {
            this.tableLock.unlock();
        }
    }
}

