/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.api.TableMeta;
import org.apache.amoro.op.MixedHadoopTableOperations;
import org.apache.amoro.server.table.TableMetadata;
import org.apache.amoro.server.table.internal.InternalIcebergHandler;
import org.apache.amoro.server.table.internal.MixedIcebergInternalTableStoreOperations;
import org.apache.amoro.server.utils.InternalTableUtil;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.utils.CatalogUtil;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.io.FileIO;

public class InternalMixedIcebergHandler
extends InternalIcebergHandler {
    private final boolean changeStore;
    private final CatalogMeta catalogMeta;

    public InternalMixedIcebergHandler(CatalogMeta catalogMeta, TableMetadata metadata, boolean changeStore) {
        super(catalogMeta, metadata);
        this.changeStore = changeStore;
        this.catalogMeta = catalogMeta;
    }

    @Override
    public TableOperations newTableOperator() {
        return this.newTableOperations(this.changeStore);
    }

    @Override
    public void dropTable(boolean purge) {
        this.checkClosed();
        if (purge && InternalTableUtil.isKeyedMixedTable(this.tableMetadata())) {
            this.purgeIceberg(this.newTableOperations(true));
        }
        super.dropTable(purge);
    }

    private TableOperations newTableOperations(boolean changeStore) {
        if (InternalTableUtil.isLegacyMixedIceberg(this.tableMetadata())) {
            TableMetaStore metaStore;
            String tableLocation = changeStore ? this.tableMetadata().getChangeLocation() : this.tableMetadata().getBaseLocation();
            MixedHadoopTableOperations ops = new MixedHadoopTableOperations(new Path(tableLocation), this.io, (metaStore = CatalogUtil.buildMetaStore((CatalogMeta)this.catalogMeta)).getConfiguration());
            org.apache.iceberg.TableMetadata current = ops.current();
            if (current == null) {
                return ops;
            }
            org.apache.iceberg.TableMetadata legacyCurrent = this.legacyTableMetadata(current, changeStore);
            if (!current.equals(legacyCurrent)) {
                ops.commit(current, legacyCurrent);
            }
            return ops;
        }
        return new MixedIcebergInternalTableStoreOperations(this.tableMetadata().getTableIdentifier(), this.tableMetadata(), (FileIO)this.io, changeStore);
    }

    private org.apache.iceberg.TableMetadata legacyTableMetadata(org.apache.iceberg.TableMetadata metadata, boolean changeStore) {
        PrimaryKeySpec keySpec = PrimaryKeySpec.noPrimaryKey();
        TableMeta tableMeta = this.tableMetadata().buildTableMeta();
        if (tableMeta.isSetKeySpec()) {
            PrimaryKeySpec.Builder keyBuilder = PrimaryKeySpec.builderFor((Schema)metadata.schema());
            tableMeta.getKeySpec().getFields().forEach(arg_0 -> ((PrimaryKeySpec.Builder)keyBuilder).addColumn(arg_0));
            keySpec = keyBuilder.build();
        }
        TableIdentifier changeIdentifier = TableIdentifier.of((String[])new String[]{this.tableMetadata().getTableIdentifier().getDatabase(), this.tableMetadata().getTableIdentifier().getTableName() + "@change"});
        HashMap properties = Maps.newHashMap((Map)metadata.properties());
        if (!changeStore) {
            properties.putAll(TablePropertyUtil.baseStoreProperties((PrimaryKeySpec)keySpec, (TableIdentifier)changeIdentifier, (TableFormat)TableFormat.MIXED_ICEBERG));
        } else {
            properties.putAll(TablePropertyUtil.changeStoreProperties((PrimaryKeySpec)keySpec, (TableFormat)TableFormat.MIXED_ICEBERG));
        }
        if (Maps.difference((Map)properties, (Map)metadata.properties()).areEqual()) {
            return metadata;
        }
        return org.apache.iceberg.TableMetadata.buildFrom((org.apache.iceberg.TableMetadata)metadata).setProperties((Map)properties).discardChanges().build();
    }
}

