/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core.security;

import io.javalin.core.security.RouteRole;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.javalin.http.util.ContextUtil;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\r"}, d2={"Lio/javalin/core/security/SecurityUtil;", "", "()V", "noopAccessManager", "", "handler", "Lio/javalin/http/Handler;", "ctx", "Lio/javalin/http/Context;", "roles", "", "Lio/javalin/core/security/RouteRole;", "sslRedirect", "javalin"})
public final class SecurityUtil {
    @NotNull
    public static final SecurityUtil INSTANCE = new SecurityUtil();

    private SecurityUtil() {
    }

    @JvmStatic
    public static final void noopAccessManager(@NotNull Handler handler, @NotNull Context ctx, @NotNull Set<? extends RouteRole> roles) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Collection collection = roles;
        boolean bl = false;
        if (!collection.isEmpty()) {
            throw new IllegalStateException("No access manager configured. Add an access manager using 'Javalin.create(c -> c.accessManager(...))'.");
        }
        handler.handle(ctx);
    }

    @JvmStatic
    public static final void sslRedirect(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ContextUtil.INSTANCE.isLocalhost(ctx)) {
            return;
        }
        String xForwardedProto = ctx.header("x-forwarded-proto");
        if (Intrinsics.areEqual((Object)xForwardedProto, (Object)"http") || xForwardedProto == null && Intrinsics.areEqual((Object)ctx.scheme(), (Object)"http")) {
            ctx.redirect(StringsKt.replace$default((String)ctx.fullUrl(), (String)"http", (String)"https", (boolean)false, (int)4, null), 301);
        }
    }
}

