/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.apache.spark.sql.execution.streaming.LongOffset$;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.sources.RateStreamMicroBatchInputPartition;
import org.apache.spark.sql.execution.streaming.sources.RateStreamMicroBatchReaderFactory$;
import org.apache.spark.sql.execution.streaming.sources.RateStreamMicroBatchStream$;
import org.apache.spark.sql.execution.streaming.sources.RateStreamProvider$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.SystemClock;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u000f\u001f\u00015B\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\r\"AQ\n\u0001B\u0001B\u0003%a\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003S\u0011!A\u0006A!A!\u0002\u0013I\u0006\"\u00023\u0001\t\u0003)\u0007\u0002C7\u0001\u0005\u0004%\tA\b8\t\rQ\u0004\u0001\u0015!\u0003p\u0011\u001d)\bA1A\u0005\nYDaa\u001e\u0001!\u0002\u00131\u0005\u0002\u0003=\u0001\u0005\u0004%\tA\b<\t\re\u0004\u0001\u0015!\u0003G\u0011\u001dQ\b\u00011A\u0005\nYDqa\u001f\u0001A\u0002\u0013%A\u0010C\u0004\u0002\u0006\u0001\u0001\u000b\u0015\u0002$\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!9\u0011\u0011\u0004\u0001\u0005B\u0005E\u0001bBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003G\u0001A\u0011IA\u0013\u0011\u001d\ti\u0004\u0001C!\u0003\u007fAq!a\u0012\u0001\t\u0003\nI\u0005C\u0004\u0002N\u0001!\t%a\u0014\t\u000f\u0005E\u0003\u0001\"\u0011\u0002T\u001dI\u0011Q\u000b\u0010\u0002\u0002#\u0005\u0011q\u000b\u0004\t;y\t\t\u0011#\u0001\u0002Z!1A-\u0007C\u0001\u0003CB\u0011\"a\u0019\u001a#\u0003%\t!!\u001a\t\u0013\u0005m\u0014$%A\u0005\u0002\u0005u$A\u0007*bi\u0016\u001cFO]3b[6K7M]8CCR\u001c\u0007n\u0015;sK\u0006l'BA\u0010!\u0003\u001d\u0019x.\u001e:dKNT!!\t\u0012\u0002\u0013M$(/Z1nS:<'BA\u0012%\u0003%)\u00070Z2vi&|gN\u0003\u0002&M\u0005\u00191/\u001d7\u000b\u0005\u001dB\u0013!B:qCJ\\'BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001]Yz\u0004CA\u00185\u001b\u0005\u0001$BA\u00193\u0003\u0011a\u0017M\\4\u000b\u0003M\nAA[1wC&\u0011Q\u0007\r\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]jT\"\u0001\u001d\u000b\u0005\u0005J$B\u0001\u001e<\u0003\u0011\u0011X-\u00193\u000b\u0005q\"\u0013!C2p]:,7\r^8s\u0013\tq\u0004H\u0001\tNS\u000e\u0014xNQ1uG\"\u001cFO]3b[B\u0011\u0001iQ\u0007\u0002\u0003*\u0011!IJ\u0001\tS:$XM\u001d8bY&\u0011A)\u0011\u0002\b\u0019><w-\u001b8h\u00035\u0011xn^:QKJ\u001cVmY8oIB\u0011qIS\u0007\u0002\u0011*\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\n!Aj\u001c8h\u0003E\u0011\u0018-\u001c9VaRKW.Z*fG>tGm]\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0011\u0005\u001d{\u0015B\u0001)I\u0005\rIe\u000e^\u0001\b_B$\u0018n\u001c8t!\t\u0019f+D\u0001U\u0015\t)F%\u0001\u0003vi&d\u0017BA,U\u0005a\u0019\u0015m]3J]N,gn]5uSZ,7\u000b\u001e:j]\u001el\u0015\r]\u0001\u0013G\",7m\u001b9pS:$Hj\\2bi&|g\u000e\u0005\u0002[C:\u00111l\u0018\t\u00039\"k\u0011!\u0018\u0006\u0003=2\na\u0001\u0010:p_Rt\u0014B\u00011I\u0003\u0019\u0001&/\u001a3fM&\u0011!m\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001D\u0015A\u0002\u001fj]&$h\b\u0006\u0004gQ&T7\u000e\u001c\t\u0003O\u0002i\u0011A\b\u0005\u0006\u000b\u001a\u0001\rA\u0012\u0005\b\u0019\u001a\u0001\n\u00111\u0001G\u0011\u001die\u0001%AA\u00029CQ!\u0015\u0004A\u0002ICQ\u0001\u0017\u0004A\u0002e\u000bQa\u00197pG.,\u0012a\u001c\t\u0003aJl\u0011!\u001d\u0006\u0003+\u001aJ!a]9\u0003\u000b\rcwnY6\u0002\r\rdwnY6!\u0003)i\u0017\r_*fG>tGm]\u000b\u0002\r\u0006YQ.\u0019=TK\u000e|g\u000eZ:!\u00039\u0019'/Z1uS>tG+[7f\u001bN\fqb\u0019:fCRLwN\u001c+j[\u0016l5\u000fI\u0001\u000bY\u0006\u001cH\u000fV5nK6\u001b\u0018A\u00047bgR$\u0016.\\3Ng~#S-\u001d\u000b\u0004{\u0006\u0005\u0001CA$\u007f\u0013\ty\bJ\u0001\u0003V]&$\b\u0002CA\u0002\u001d\u0005\u0005\t\u0019\u0001$\u0002\u0007a$\u0013'A\u0006mCN$H+[7f\u001bN\u0004\u0003fA\b\u0002\nA\u0019q)a\u0003\n\u0007\u00055\u0001J\u0001\u0005w_2\fG/\u001b7f\u00035Ig.\u001b;jC2|eMZ:fiR\u0011\u00111\u0003\t\u0004o\u0005U\u0011bAA\fq\t1qJ\u001a4tKR\fA\u0002\\1uKN$xJ\u001a4tKR\f\u0011\u0003Z3tKJL\u0017\r\\5{K>3gm]3u)\u0011\t\u0019\"a\b\t\r\u0005\u0005\"\u00031\u0001Z\u0003\u0011Q7o\u001c8\u0002'Ad\u0017M\\%oaV$\b+\u0019:uSRLwN\\:\u0015\r\u0005\u001d\u0012QGA\u001d!\u00159\u0015\u0011FA\u0017\u0013\r\tY\u0003\u0013\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003_\t\t$D\u0001:\u0013\r\t\u0019$\u000f\u0002\u000f\u0013:\u0004X\u000f\u001e)beRLG/[8o\u0011\u001d\t9d\u0005a\u0001\u0003'\tQa\u001d;beRDq!a\u000f\u0014\u0001\u0004\t\u0019\"A\u0002f]\u0012\f1c\u0019:fCR,'+Z1eKJ4\u0015m\u0019;pef$\"!!\u0011\u0011\t\u0005=\u00121I\u0005\u0004\u0003\u000bJ$A\u0006)beRLG/[8o%\u0016\fG-\u001a:GC\u000e$xN]=\u0002\r\r|W.\\5u)\ri\u00181\n\u0005\b\u0003w)\u0002\u0019AA\n\u0003\u0011\u0019Ho\u001c9\u0015\u0003u\f\u0001\u0002^8TiJLgn\u001a\u000b\u00023\u0006Q\"+\u0019;f'R\u0014X-Y7NS\u000e\u0014xNQ1uG\"\u001cFO]3b[B\u0011q-G\n\u00043\u0005m\u0003cA$\u0002^%\u0019\u0011q\f%\u0003\r\u0005s\u0017PU3g)\t\t9&A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003OR3ARA5W\t\tY\u0007\u0005\u0003\u0002n\u0005]TBAA8\u0015\u0011\t\t(a\u001d\u0002\u0013Ut7\r[3dW\u0016$'bAA;\u0011\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0014q\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0000)\u001aa*!\u001b")
public class RateStreamMicroBatchStream
implements MicroBatchStream,
Logging {
    private final long rowsPerSecond;
    private final long rampUpTimeSeconds;
    private final int numPartitions;
    private final CaseInsensitiveStringMap options;
    public final String org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchStream$$checkpointLocation;
    private final Clock clock;
    private final long maxSeconds;
    private final long creationTimeMs;
    private volatile long lastTimeMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int $lessinit$greater$default$3() {
        return RateStreamMicroBatchStream$.MODULE$.$lessinit$greater$default$3();
    }

    public static long $lessinit$greater$default$2() {
        return RateStreamMicroBatchStream$.MODULE$.$lessinit$greater$default$2();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Clock clock() {
        return this.clock;
    }

    private long maxSeconds() {
        return this.maxSeconds;
    }

    public long creationTimeMs() {
        return this.creationTimeMs;
    }

    private long lastTimeMs() {
        return this.lastTimeMs;
    }

    private void lastTimeMs_$eq(long x$1) {
        this.lastTimeMs = x$1;
    }

    public Offset initialOffset() {
        return new LongOffset(0L);
    }

    public Offset latestOffset() {
        long now = this.clock().getTimeMillis();
        if (this.lastTimeMs() < now) {
            this.lastTimeMs_$eq(now);
        }
        return new LongOffset(TimeUnit.MILLISECONDS.toSeconds(this.lastTimeMs() - this.creationTimeMs()));
    }

    public Offset deserializeOffset(String json) {
        return new LongOffset(new StringOps(Predef$.MODULE$.augmentString(json)).toLong());
    }

    public InputPartition[] planInputPartitions(Offset start, Offset end) {
        long endSeconds;
        long startSeconds = ((LongOffset)start).offset();
        Predef$.MODULE$.assert(startSeconds <= (endSeconds = ((LongOffset)end).offset()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("startSeconds(").append(startSeconds).append(") > endSeconds(").append(endSeconds).append(")").toString());
        if (endSeconds > this.maxSeconds()) {
            throw QueryExecutionErrors$.MODULE$.integerOverflowError(new StringBuilder(50).append("Max offset with ").append(this.rowsPerSecond).append(" rowsPerSecond is ").append(this.maxSeconds()).append(", but it's ").append(endSeconds).append(" now.").toString());
        }
        if (this.lastTimeMs() < TimeUnit.SECONDS.toMillis(endSeconds) + this.creationTimeMs()) {
            this.lastTimeMs_$eq(TimeUnit.SECONDS.toMillis(endSeconds) + this.creationTimeMs());
        }
        long rangeStart = RateStreamProvider$.MODULE$.valueAtSecond(startSeconds, this.rowsPerSecond, this.rampUpTimeSeconds);
        long rangeEnd = RateStreamProvider$.MODULE$.valueAtSecond(endSeconds, this.rowsPerSecond, this.rampUpTimeSeconds);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("startSeconds: ").append(startSeconds).append(", endSeconds: ").append(endSeconds).append(", ").append("rangeStart: ").append(rangeStart).append(", rangeEnd: ").append(rangeEnd).toString());
        if (rangeStart == rangeEnd) {
            return (InputPartition[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InputPartition.class));
        }
        long localStartTimeMs = this.creationTimeMs() + TimeUnit.SECONDS.toMillis(startSeconds);
        double relativeMsPerValue = (double)TimeUnit.SECONDS.toMillis(endSeconds - startSeconds) / (double)(rangeEnd - rangeStart);
        return (InputPartition[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions).map((Function1 & Serializable & scala.Serializable)p -> RateStreamMicroBatchStream.$anonfun$planInputPartitions$3(this, rangeStart, rangeEnd, localStartTimeMs, relativeMsPerValue, BoxesRunTime.unboxToInt((Object)p)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public PartitionReaderFactory createReaderFactory() {
        return RateStreamMicroBatchReaderFactory$.MODULE$;
    }

    public void commit(Offset end) {
    }

    public void stop() {
    }

    public String toString() {
        return new StringBuilder(63).append("RateStreamV2[rowsPerSecond=").append(this.rowsPerSecond).append(", ").append("rampUpTimeSeconds=").append(this.rampUpTimeSeconds).append(", ").append("numPartitions=").append(this.options.getOrDefault((Object)RateStreamProvider$.MODULE$.NUM_PARTITIONS(), (Object)"default")).toString();
    }

    public static final /* synthetic */ RateStreamMicroBatchInputPartition $anonfun$planInputPartitions$3(RateStreamMicroBatchStream $this, long rangeStart$1, long rangeEnd$1, long localStartTimeMs$1, double relativeMsPerValue$1, int p) {
        return new RateStreamMicroBatchInputPartition(p, $this.numPartitions, rangeStart$1, rangeEnd$1, localStartTimeMs$1, relativeMsPerValue$1);
    }

    public RateStreamMicroBatchStream(long rowsPerSecond, long rampUpTimeSeconds, int numPartitions, CaseInsensitiveStringMap options, String checkpointLocation) {
        this.rowsPerSecond = rowsPerSecond;
        this.rampUpTimeSeconds = rampUpTimeSeconds;
        this.numPartitions = numPartitions;
        this.options = options;
        this.org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchStream$$checkpointLocation = checkpointLocation;
        Logging.$init$((Logging)this);
        this.clock = options.getBoolean("useManualClock", false) ? new ManualClock() : new SystemClock();
        this.maxSeconds = Long.MAX_VALUE / rowsPerSecond;
        if (rampUpTimeSeconds > this.maxSeconds()) {
            throw QueryExecutionErrors$.MODULE$.integerOverflowError(new StringBuilder(64).append("Max offset with ").append(rowsPerSecond).append(" rowsPerSecond").append(" is ").append(this.maxSeconds()).append(", but 'rampUpTimeSeconds' is ").append(rampUpTimeSeconds).append(".").toString());
        }
        Option session = SparkSession$.MODULE$.getActiveSession().orElse((Function0 & Serializable & scala.Serializable)() -> SparkSession$.MODULE$.getDefaultSession());
        Predef$.MODULE$.require(session.isDefined());
        HDFSMetadataLog<LongOffset> metadataLog = new HDFSMetadataLog<LongOffset>(this, session){

            public void serialize(LongOffset metadata, OutputStream out) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
                writer.write(new StringBuilder(2).append("v").append(RateStreamProvider$.MODULE$.VERSION()).append("\n").toString());
                writer.write(metadata.json());
                writer.flush();
            }

            public LongOffset deserialize(InputStream in) {
                int indexOfNewLine;
                String content = IOUtils.toString((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
                Predef$.MODULE$.assert(content.length() != 0);
                if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(content), 0) == 'v') {
                    indexOfNewLine = content.indexOf("\n");
                    if (indexOfNewLine <= 0) {
                        throw new IllegalStateException("Log file was malformed: failed to detect the log file version line.");
                    }
                } else {
                    throw new IllegalStateException("Log file was malformed: failed to detect the log file version line.");
                }
                this.validateVersion(content.substring(0, indexOfNewLine), RateStreamProvider$.MODULE$.VERSION());
                return LongOffset$.MODULE$.apply(new SerializedOffset(content.substring(indexOfNewLine + 1)));
            }
        };
        this.creationTimeMs = ((LongOffset)((Object)metadataLog.get(0L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            LongOffset offset = new LongOffset(this.clock().getTimeMillis());
            metadataLog.add(0L, offset);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Start time: ").append((Object)offset).toString());
            return var2_2;
        }))).offset();
        this.lastTimeMs = this.creationTimeMs();
    }
}

