/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.shuffle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.disk.DiskTierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.memory.MemoryTierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteTierFactory;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class TierFactoryInitializer {
    public static List<TierFactory> initializeTierFactories(Configuration configuration) {
        String externalTierFactoryClass = (String)configuration.get(NettyShuffleEnvironmentOptions.NETWORK_HYBRID_SHUFFLE_EXTERNAL_REMOTE_TIER_FACTORY_CLASS_NAME);
        if (externalTierFactoryClass != null) {
            return Collections.singletonList(TierFactoryInitializer.createExternalTierFactory(configuration, externalTierFactoryClass));
        }
        return TierFactoryInitializer.getEphemeralTierFactories(configuration);
    }

    private static List<TierFactory> getEphemeralTierFactories(Configuration configuration) {
        String externalTierFactoryClass = (String)configuration.get(NettyShuffleEnvironmentOptions.NETWORK_HYBRID_SHUFFLE_EXTERNAL_REMOTE_TIER_FACTORY_CLASS_NAME);
        String remoteStoragePath = (String)configuration.get(NettyShuffleEnvironmentOptions.NETWORK_HYBRID_SHUFFLE_REMOTE_STORAGE_BASE_PATH);
        ArrayList<TierFactory> tierFactories = new ArrayList<TierFactory>();
        tierFactories.add(TierFactoryInitializer.createMemoryTierFactory(configuration));
        tierFactories.add(TierFactoryInitializer.createDiskTierFactory(configuration));
        if (externalTierFactoryClass != null) {
            tierFactories.add(TierFactoryInitializer.createExternalTierFactory(configuration, externalTierFactoryClass));
        } else if (remoteStoragePath != null) {
            tierFactories.add(TierFactoryInitializer.createRemoteTierFactory(configuration));
        }
        return tierFactories;
    }

    private static MemoryTierFactory createMemoryTierFactory(Configuration configuration) {
        MemoryTierFactory memoryTierFactory = new MemoryTierFactory();
        memoryTierFactory.setup(configuration);
        return memoryTierFactory;
    }

    private static DiskTierFactory createDiskTierFactory(Configuration configuration) {
        DiskTierFactory diskTierFactory = new DiskTierFactory();
        diskTierFactory.setup(configuration);
        return diskTierFactory;
    }

    private static RemoteTierFactory createRemoteTierFactory(Configuration configuration) {
        RemoteTierFactory remoteTierFactory = new RemoteTierFactory();
        remoteTierFactory.setup(configuration);
        return remoteTierFactory;
    }

    private static TierFactory createExternalTierFactory(Configuration configuration, String externalTierFactoryClassName) {
        Preconditions.checkNotNull((Object)externalTierFactoryClassName);
        TierFactory tierFactory = TierFactoryInitializer.loadTierFactory(externalTierFactoryClassName);
        tierFactory.setup(configuration);
        return tierFactory;
    }

    private static TierFactory loadTierFactory(String tierFactoryClassName) {
        TierFactory tierFactory = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            tierFactory = (TierFactory)InstantiationUtil.instantiate((String)tierFactoryClassName, TierFactory.class, (ClassLoader)classLoader);
        }
        catch (FlinkException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
        return tierFactory;
    }
}

