/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.time.Duration;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RpcOptions;
import org.apache.flink.runtime.registration.RetryingRegistrationConfiguration;
import org.apache.flink.util.Preconditions;

public class JobMasterConfiguration {
    private final Time rpcTimeout;
    private final Time slotRequestTimeout;
    private final String tmpDirectory;
    private final RetryingRegistrationConfiguration retryingRegistrationConfiguration;
    private final Configuration configuration;

    public JobMasterConfiguration(Time rpcTimeout, Time slotRequestTimeout, String tmpDirectory, RetryingRegistrationConfiguration retryingRegistrationConfiguration, Configuration configuration) {
        this.rpcTimeout = (Time)Preconditions.checkNotNull((Object)rpcTimeout);
        this.slotRequestTimeout = (Time)Preconditions.checkNotNull((Object)slotRequestTimeout);
        this.tmpDirectory = (String)Preconditions.checkNotNull((Object)tmpDirectory);
        this.retryingRegistrationConfiguration = retryingRegistrationConfiguration;
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
    }

    public Time getRpcTimeout() {
        return this.rpcTimeout;
    }

    public Time getSlotRequestTimeout() {
        return this.slotRequestTimeout;
    }

    public String getTmpDirectory() {
        return this.tmpDirectory;
    }

    public RetryingRegistrationConfiguration getRetryingRegistrationConfiguration() {
        return this.retryingRegistrationConfiguration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public static JobMasterConfiguration fromConfiguration(Configuration configuration) {
        Time rpcTimeout = Time.fromDuration((Duration)((Duration)configuration.get(RpcOptions.ASK_TIMEOUT_DURATION)));
        Time slotRequestTimeout = Time.fromDuration((Duration)((Duration)configuration.get(JobManagerOptions.SLOT_REQUEST_TIMEOUT)));
        String tmpDirectory = ConfigurationUtils.parseTempDirectories((Configuration)configuration)[0];
        RetryingRegistrationConfiguration retryingRegistrationConfiguration = RetryingRegistrationConfiguration.fromConfiguration(configuration);
        return new JobMasterConfiguration(rpcTimeout, slotRequestTimeout, tmpDirectory, retryingRegistrationConfiguration, configuration);
    }
}

