/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.progress;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.listener.AsyncRequestBodyListener;
import software.amazon.awssdk.core.async.listener.AsyncResponseTransformerListener;
import software.amazon.awssdk.core.async.listener.PublisherListener;
import software.amazon.awssdk.crt.s3.S3MetaRequestProgress;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.transfer.s3.internal.progress.DefaultTransferProgress;
import software.amazon.awssdk.transfer.s3.internal.progress.DefaultTransferProgressSnapshot;
import software.amazon.awssdk.transfer.s3.internal.progress.TransferListenerContext;
import software.amazon.awssdk.transfer.s3.internal.progress.TransferListenerFailedContext;
import software.amazon.awssdk.transfer.s3.internal.progress.TransferListenerInvoker;
import software.amazon.awssdk.transfer.s3.model.CompletedObjectTransfer;
import software.amazon.awssdk.transfer.s3.model.TransferObjectRequest;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;
import software.amazon.awssdk.transfer.s3.progress.TransferProgress;
import software.amazon.awssdk.transfer.s3.progress.TransferProgressSnapshot;

@SdkInternalApi
public class TransferProgressUpdater {
    private final DefaultTransferProgress progress;
    private final TransferListenerContext context;
    private final TransferListenerInvoker listenerInvoker;
    private final CompletableFuture<Void> endOfStreamFuture;

    public TransferProgressUpdater(TransferObjectRequest request, Long contentLength) {
        DefaultTransferProgressSnapshot.Builder snapshotBuilder = DefaultTransferProgressSnapshot.builder();
        snapshotBuilder.transferredBytes(0L);
        Optional.ofNullable(contentLength).ifPresent(snapshotBuilder::totalBytes);
        DefaultTransferProgressSnapshot snapshot = snapshotBuilder.build();
        this.progress = new DefaultTransferProgress(snapshot);
        this.context = TransferListenerContext.builder().request(request).progressSnapshot(snapshot).build();
        this.listenerInvoker = request.transferListeners() == null ? new TransferListenerInvoker(Collections.emptyList()) : new TransferListenerInvoker(request.transferListeners());
        this.endOfStreamFuture = new CompletableFuture();
    }

    public TransferProgress progress() {
        return this.progress;
    }

    public void transferInitiated() {
        this.listenerInvoker.transferInitiated(this.context);
    }

    public AsyncRequestBody wrapRequestBody(AsyncRequestBody requestBody) {
        return AsyncRequestBodyListener.wrap((AsyncRequestBody)requestBody, (AsyncRequestBodyListener)new AsyncRequestBodyListener(){
            final AtomicBoolean done = new AtomicBoolean(false);

            public void publisherSubscribe(Subscriber<? super ByteBuffer> subscriber) {
                TransferProgressUpdater.this.resetBytesTransferred();
            }

            public void subscriberOnNext(ByteBuffer byteBuffer) {
                TransferProgressUpdater.this.incrementBytesTransferred(byteBuffer.limit());
                TransferProgressUpdater.this.progress.snapshot().ratioTransferred().ifPresent(ratioTransferred -> {
                    if (Double.compare(ratioTransferred, 1.0) == 0) {
                        this.endOfStreamFutureCompleted();
                    }
                });
            }

            public void subscriberOnError(Throwable t) {
                TransferProgressUpdater.this.transferFailed(t);
            }

            public void subscriberOnComplete() {
                this.endOfStreamFutureCompleted();
            }

            private void endOfStreamFutureCompleted() {
                if (this.done.compareAndSet(false, true)) {
                    TransferProgressUpdater.this.endOfStreamFuture.complete(null);
                }
            }
        });
    }

    public PublisherListener<Long> multipartClientProgressListener() {
        return new PublisherListener<Long>(){

            public void publisherSubscribe(Subscriber<? super Long> subscriber) {
                TransferProgressUpdater.this.resetBytesTransferred();
            }

            public void subscriberOnNext(Long contentLength) {
                TransferProgressUpdater.this.incrementBytesTransferred(contentLength);
            }

            public void subscriberOnError(Throwable t) {
                TransferProgressUpdater.this.transferFailed(t);
            }

            public void subscriberOnComplete() {
                TransferProgressUpdater.this.endOfStreamFuture.complete(null);
            }
        };
    }

    public PublisherListener<S3MetaRequestProgress> crtProgressListener() {
        return new PublisherListener<S3MetaRequestProgress>(){

            public void publisherSubscribe(Subscriber<? super S3MetaRequestProgress> subscriber) {
                TransferProgressUpdater.this.resetBytesTransferred();
            }

            public void subscriberOnNext(S3MetaRequestProgress s3MetaRequestProgress) {
                TransferProgressUpdater.this.incrementBytesTransferred(s3MetaRequestProgress.getBytesTransferred());
            }

            public void subscriberOnError(Throwable t) {
                TransferProgressUpdater.this.transferFailed(t);
            }

            public void subscriberOnComplete() {
                TransferProgressUpdater.this.endOfStreamFuture.complete(null);
            }
        };
    }

    public <ResultT> AsyncResponseTransformer<GetObjectResponse, ResultT> wrapResponseTransformer(AsyncResponseTransformer<GetObjectResponse, ResultT> responseTransformer) {
        return AsyncResponseTransformerListener.wrap(responseTransformer, (AsyncResponseTransformerListener)new AsyncResponseTransformerListener<GetObjectResponse>(){

            public void transformerOnResponse(GetObjectResponse response) {
                if (response.contentLength() != null) {
                    TransferProgressUpdater.this.progress.updateAndGet(b -> b.totalBytes(response.contentLength()).sdkResponse((SdkResponse)response));
                }
            }

            public void transformerExceptionOccurred(Throwable t) {
                TransferProgressUpdater.this.transferFailed(t);
            }

            public void publisherSubscribe(Subscriber<? super ByteBuffer> subscriber) {
                TransferProgressUpdater.this.resetBytesTransferred();
            }

            public void subscriberOnNext(ByteBuffer byteBuffer) {
                TransferProgressUpdater.this.incrementBytesTransferred(byteBuffer.limit());
            }

            public void subscriberOnError(Throwable t) {
                TransferProgressUpdater.this.transferFailed(t);
            }

            public void subscriberOnComplete() {
                TransferProgressUpdater.this.endOfStreamFuture.complete(null);
            }
        });
    }

    private void resetBytesTransferred() {
        this.progress.updateAndGet(b -> b.transferredBytes(0L));
    }

    private void incrementBytesTransferred(long numBytes) {
        TransferProgressSnapshot snapshot = this.progress.updateAndGet(b -> b.transferredBytes(b.getTransferredBytes() + numBytes));
        this.listenerInvoker.bytesTransferred((TransferListener.Context.BytesTransferred)this.context.copy(b -> b.progressSnapshot(snapshot)));
    }

    public void registerCompletion(CompletableFuture<? extends CompletedObjectTransfer> future) {
        future.whenComplete((r, t) -> {
            if (t == null) {
                this.endOfStreamFuture.whenComplete((r2, t2) -> {
                    if (t2 == null) {
                        this.transferComplete((CompletedObjectTransfer)r);
                    } else {
                        this.transferFailed((Throwable)t2);
                    }
                });
            } else {
                this.transferFailed((Throwable)t);
            }
        });
    }

    private void transferComplete(CompletedObjectTransfer r) {
        this.listenerInvoker.transferComplete((TransferListener.Context.TransferComplete)this.context.copy(b -> {
            TransferProgressSnapshot snapshot = this.progress.snapshot();
            if (!snapshot.sdkResponse().isPresent()) {
                snapshot = this.progress.updateAndGet(p -> p.sdkResponse(r.response()));
            }
            b.progressSnapshot(snapshot);
            b.completedTransfer(r);
        }));
    }

    private void transferFailed(Throwable t) {
        this.listenerInvoker.transferFailed(TransferListenerFailedContext.builder().transferContext((TransferListenerContext)this.context.copy(b -> b.progressSnapshot(this.progress.snapshot()))).exception(t).build());
    }
}

