/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.geometry.wrapper.GeometryType;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.metadata.sql.util.SQLBuilder;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.util.DefinitionVerifier;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.Resources;
import org.apache.sis.storage.sql.feature.TableReference;
import org.apache.sis.storage.sql.feature.ValueGetter;
import org.apache.sis.util.Localized;
import org.apache.sis.util.Utilities;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class InfoStatements
implements Localized,
AutoCloseable {
    static final String SPATIAL_REF_SYS = "SPATIAL_REF_SYS";
    static final String GEOMETRY_COLUMNS = "GEOMETRY_COLUMNS";
    private final Database<?> database;
    private final Connection connection;
    protected PreparedStatement geometryColumns;
    private PreparedStatement wktFromSrid;
    private PreparedStatement sridFromCRS;
    private WKTFormat wktReader;

    protected InfoStatements(Database<?> database, Connection connection) {
        this.database = database;
        this.connection = connection;
    }

    public final Locale getLocale() {
        return this.database.listeners.getLocale();
    }

    public final ValueGetter<?> getComponentMapping(Array array) throws SQLException {
        return this.database.getMapping(new Column(array.getBaseType(), array.getBaseTypeName()));
    }

    private void appendFrom(SQLBuilder sql, String table) {
        this.database.appendFunctionCall(sql.append(" FROM "), table);
        sql.append(" WHERE ");
    }

    private static SQLBuilder appendCondition(SQLBuilder sql, char prefix, String column) {
        return sql.append(prefix).append('_').append(column).append(" = ?");
    }

    protected final PreparedStatement prepareIntrospectionStatement(String table, char prefix, String column, String otherColumn) throws SQLException {
        SQLBuilder sql = new SQLBuilder(this.database).append("SELECT ").append(prefix).append('_').append(column).append(", SRID ");
        if (otherColumn != null) {
            sql.append(", ").append(otherColumn);
        }
        this.appendFrom(sql, table);
        if (this.database.supportsCatalogs) {
            InfoStatements.appendCondition(sql, prefix, "TABLE_CATALOG").append(" AND ");
        }
        if (this.database.supportsSchemas) {
            InfoStatements.appendCondition(sql, prefix, "TABLE_SCHEMA").append(" AND ");
        }
        InfoStatements.appendCondition(sql, prefix, "TABLE_NAME");
        return this.connection.prepareStatement(sql.toString());
    }

    public void completeIntrospection(TableReference source, Map<String, Column> columns) throws Exception {
        if (this.geometryColumns == null) {
            this.geometryColumns = this.prepareIntrospectionStatement(GEOMETRY_COLUMNS, 'F', "GEOMETRY_COLUMN", "GEOMETRY_TYPE");
        }
        this.configureSpatialColumns(this.geometryColumns, source, columns, GeometryTypeEncoding.NUMERIC);
    }

    protected final void configureSpatialColumns(PreparedStatement columnQuery, TableReference source, Map<String, Column> columns, GeometryTypeEncoding typeValueKind) throws Exception {
        int p = 0;
        if (this.database.supportsCatalogs) {
            columnQuery.setString(++p, source.catalog);
        }
        if (this.database.supportsSchemas) {
            columnQuery.setString(++p, source.schema);
        }
        columnQuery.setString(++p, source.table);
        try (ResultSet result = columnQuery.executeQuery();){
            while (result.next()) {
                Column target = columns.get(result.getString(1));
                if (target == null) continue;
                CoordinateReferenceSystem crs = this.fetchCRS(result.getInt(2));
                GeometryType type = null;
                if (typeValueKind != null && (type = typeValueKind.parse(result, 3)) == null) {
                    type = GeometryType.GEOMETRY;
                }
                target.makeSpatial(this, type, crs);
            }
        }
    }

    public final CoordinateReferenceSystem fetchCRS(int srid) throws Exception {
        if (srid <= 0) {
            return null;
        }
        return (CoordinateReferenceSystem)this.database.cacheOfCRS.getOrCreate((Object)srid, () -> this.parseCRS(srid));
    }

    private CoordinateReferenceSystem parseCRS(int srid) throws Exception {
        if (this.wktFromSrid == null) {
            SQLBuilder sql = new SQLBuilder(this.database);
            sql.append("SELECT auth_name, auth_srid, srtext");
            this.appendFrom(sql, SPATIAL_REF_SYS);
            sql.append("srid=?");
            this.wktFromSrid = this.connection.prepareStatement(sql.toString());
        }
        this.wktFromSrid.setInt(1, srid);
        CoordinateReferenceSystem crs = null;
        NoSuchAuthorityCodeException authorityError = null;
        LogRecord warning = null;
        try (ResultSet result = this.wktFromSrid.executeQuery();){
            while (result.next()) {
                Warnings w;
                CoordinateReferenceSystem fromAuthority = null;
                String authority = result.getString(1);
                if (authority != null && !authority.isEmpty()) {
                    int code = result.getInt(2);
                    if (!result.wasNull()) {
                        try {
                            CRSAuthorityFactory factory = CRS.getAuthorityFactory((String)authority);
                            fromAuthority = factory.createCoordinateReferenceSystem(Integer.toString(code));
                        }
                        catch (NoSuchAuthorityCodeException e) {
                            authorityError = e;
                        }
                    }
                }
                CoordinateReferenceSystem fromWKT = null;
                String wkt = result.getString(3);
                if (wkt != null && !wkt.isEmpty()) {
                    Object parsed;
                    try {
                        parsed = this.wktReader().parseObject(wkt);
                    }
                    catch (ParseException e) {
                        if (authorityError != null) {
                            e.addSuppressed(authorityError);
                        }
                        throw e;
                    }
                    if (parsed instanceof CoordinateReferenceSystem) {
                        fromWKT = (CoordinateReferenceSystem)parsed;
                    } else {
                        throw this.invalidSRID((short)11, ReferencingUtilities.getInterface((Object)parsed), srid, authorityError);
                    }
                }
                DefinitionVerifier v = DefinitionVerifier.compare(fromWKT, fromAuthority, (Locale)this.getLocale());
                if (v.recommendation == null) continue;
                if (crs == null) {
                    crs = v.recommendation;
                } else if (!crs.equals(v.recommendation)) {
                    throw this.invalidSRID((short)9, SPATIAL_REF_SYS, srid, authorityError);
                }
                if ((warning = v.warning(false)) != null || fromWKT == null || (w = this.wktReader.getWarnings()) == null) continue;
                warning = new LogRecord(Level.WARNING, w.toString(this.getLocale()));
            }
        }
        if (crs == null) {
            if (authorityError != null) {
                throw authorityError;
            }
            throw this.invalidSRID((short)10, SPATIAL_REF_SYS, srid, null);
        }
        if (warning != null) {
            warning.setLoggerName("org.apache.sis.sql");
            warning.setSourceClassName(this.getClass().getName());
            warning.setSourceMethodName("fetchCRS");
            this.database.listeners.warning(warning);
        }
        return crs;
    }

    private DataStoreContentException invalidSRID(short message, Object complement, int srid, NoSuchAuthorityCodeException suppressed) {
        DataStoreContentException e = new DataStoreContentException(Resources.forLocale(this.getLocale()).getString(message, complement, srid));
        if (suppressed != null) {
            e.addSuppressed((Throwable)suppressed);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int findSRID(CoordinateReferenceSystem crs) throws Exception {
        if (crs == null) {
            return 0;
        }
        WeakHashMap<CoordinateReferenceSystem, Integer> weakHashMap = this.database.cacheOfSRID;
        synchronized (weakHashMap) {
            Integer srid = this.database.cacheOfSRID.get(crs);
            if (srid != null) {
                return srid;
            }
        }
        HashSet<AbstractMap.SimpleImmutableEntry<String, String>> done = new HashSet<AbstractMap.SimpleImmutableEntry<String, String>>();
        Iterator alternatives = null;
        CoordinateReferenceSystem candidate = crs;
        Exception error = null;
        block14: while (true) {
            Iterator iterator = candidate.getIdentifiers().iterator();
            block15: while (true) {
                int codeValue;
                String authority;
                if (iterator.hasNext()) {
                    String code;
                    ReferenceIdentifier id = (ReferenceIdentifier)iterator.next();
                    authority = id.getCodeSpace();
                    if (authority == null || !done.add(new AbstractMap.SimpleImmutableEntry<String, String>(authority, code = id.getCode()))) continue;
                    try {
                        codeValue = Integer.parseInt(code);
                    }
                    catch (NumberFormatException e) {
                        if (error == null) {
                            error = e;
                            continue;
                        }
                        error.addSuppressed(e);
                        continue;
                    }
                    if (this.sridFromCRS == null) {
                        SQLBuilder sql = new SQLBuilder(this.database);
                        sql.append("SELECT srtext, srid");
                        this.appendFrom(sql, SPATIAL_REF_SYS);
                        sql.append("auth_name=? AND auth_srid=?");
                        this.sridFromCRS = this.connection.prepareStatement(sql.toString());
                    }
                } else {
                    if (alternatives == null) {
                        IdentifiedObjectFinder finder = IdentifiedObjects.newFinder((String)"EPSG");
                        finder.setIgnoringAxes(true);
                        alternatives = finder.find((IdentifiedObject)crs).iterator();
                    }
                    if (!alternatives.hasNext()) {
                        throw new DataStoreReferencingException(Resources.format((short)15, IdentifiedObjects.getDisplayName((IdentifiedObject)crs, null)), error);
                    }
                    candidate = (IdentifiedObject)alternatives.next();
                    continue block14;
                }
                this.sridFromCRS.setString(1, authority);
                this.sridFromCRS.setInt(2, codeValue);
                ResultSet result = this.sridFromCRS.executeQuery();
                try {
                    while (true) {
                        if (!result.next()) continue block15;
                        String wkt = result.getString(1);
                        if (wkt == null || wkt.isEmpty()) continue;
                        try {
                            Object parsed = this.wktReader().parseObject(wkt);
                            if (!Utilities.equalsApproximately((Object)parsed, (Object)crs)) continue;
                            int srid = result.getInt(2);
                            WeakHashMap<CoordinateReferenceSystem, Integer> weakHashMap2 = this.database.cacheOfSRID;
                            synchronized (weakHashMap2) {
                                this.database.cacheOfSRID.put(crs, srid);
                            }
                            int n = srid;
                            return n;
                        }
                        catch (ParseException e) {
                            if (error == null) {
                                error = e;
                                continue;
                            }
                            error.addSuppressed(e);
                        }
                    }
                }
                finally {
                    if (result == null) continue;
                    result.close();
                    continue;
                }
                break;
            }
            break;
        }
    }

    private WKTFormat wktReader() {
        if (this.wktReader == null) {
            this.wktReader = new WKTFormat(null, null);
            this.wktReader.setConvention(Convention.WKT1_COMMON_UNITS);
        }
        return this.wktReader;
    }

    @Override
    public void close() throws SQLException {
        if (this.geometryColumns != null) {
            this.geometryColumns.close();
            this.geometryColumns = null;
        }
        if (this.wktFromSrid != null) {
            this.wktFromSrid.close();
            this.wktFromSrid = null;
        }
        if (this.sridFromCRS != null) {
            this.sridFromCRS.close();
            this.sridFromCRS = null;
        }
    }

    protected static enum GeometryTypeEncoding {
        NUMERIC,
        TEXTUAL{

            @Override
            GeometryType parse(ResultSet result, int columnIndex) throws SQLException {
                return GeometryType.forName((String)result.getString(columnIndex));
            }
        };


        GeometryType parse(ResultSet result, int columnIndex) throws SQLException {
            int code = result.getInt(columnIndex);
            return result.wasNull() ? null : GeometryType.forBinaryType((int)code);
        }
    }
}

