/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.oapi.features.json;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Crs {
    public static final Pattern PATTERN = Pattern.compile("http.+/([^/]+)/([^/]+)/([^/]+)$");
    public static final int PATTERN_AUTHORITY_GROUP = 1;
    public static final int PATTERN_VERSION_GROUP = 2;
    public static final int PATTERN_CODE_GROUP = 3;
    public static final String BASE_URL = "http://www.opengis.net/def/crs";
    private String authority;
    private String version;
    private String code;

    public Crs() {
    }

    public Crs(String crs) {
        this.setCrs(crs);
    }

    public Crs(String authority, String version, String code) {
        this.authority = authority;
        this.version = version;
        this.code = code;
    }

    public boolean setCrs(String crs) {
        boolean valid = false;
        Matcher matcher = PATTERN.matcher(crs);
        if (matcher.find()) {
            this.authority = matcher.group(1);
            this.version = matcher.group(2);
            this.code = matcher.group(3);
            valid = true;
        }
        return valid;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean isValid() {
        return this.authority != null && this.version != null && this.code != null;
    }

    public String toString() {
        return "http://www.opengis.net/def/crs/" + this.authority + "/" + this.version + "/" + this.code;
    }
}

