/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.GeodeticOperation;
import org.apache.sis.referencing.operation.provider.GeographicToGeocentric;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

public final class GeocentricToGeographic
extends GeodeticOperation {
    private static final long serialVersionUID = 8459294628751497567L;
    public static final String NAME = "Geocentric_To_Ellipsoid";
    public static final ParameterDescriptorGroup PARAMETERS = ((ParameterBuilder)GeocentricToGeographic.builder().addName((Citation)Citations.OGC, "Geocentric_To_Ellipsoid")).createGroupForMapProjection(GeographicToGeocentric.DIMENSION);
    private static final GeocentricToGeographic[] REDIMENSIONED = new GeocentricToGeographic[4];

    @Override
    final GeodeticOperation redimensioned(int indexOfDim) {
        return REDIMENSIONED[indexOfDim];
    }

    @Deprecated
    public GeocentricToGeographic() {
        super(REDIMENSIONED[3]);
    }

    private GeocentricToGeographic(int indexOfDim) {
        super(Conversion.class, PARAMETERS, indexOfDim, CartesianCS.class, false, EllipsoidalCS.class, true);
    }

    @Override
    public AbstractProvider inverse() {
        return null;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws FactoryException {
        MathTransform tr = GeographicToGeocentric.create(factory, Parameters.castOrWrap(values));
        try {
            tr = tr.inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new FactoryException((Throwable)e);
        }
        return tr;
    }

    static {
        GeocentricToGeographic.REDIMENSIONED[2] = new GeocentricToGeographic(2);
        GeocentricToGeographic.REDIMENSIONED[3] = new GeocentricToGeographic(3);
    }
}

