/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.collection;

import com.google.common.collect.Streams;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.baremaps.data.collection.AppendOnlyLog;
import org.apache.baremaps.data.collection.DataMap;

public class IndexedDataMap<E>
implements DataMap<Long, E> {
    private final Map<Long, Long> index;
    private final AppendOnlyLog<E> values;

    public IndexedDataMap(AppendOnlyLog<E> values) {
        this(new HashMap<Long, Long>(), values);
    }

    public IndexedDataMap(Map<Long, Long> index, AppendOnlyLog<E> values) {
        this.index = index;
        this.values = values;
    }

    @Override
    public E put(Long key, E value) {
        Long oldIndex = this.index.get(key);
        long position = this.values.addPositioned(value);
        this.index.put(key, position);
        return oldIndex == null ? null : (E)this.values.getPositioned(oldIndex);
    }

    @Override
    public E get(Object key) {
        Long position = this.index.get(key);
        return position == null ? null : (E)this.values.getPositioned(position);
    }

    @Override
    public Iterator<Long> keyIterator() {
        return this.index.keySet().iterator();
    }

    @Override
    public Iterator<E> valueIterator() {
        return Streams.stream(this.keyIterator()).map(this::get).iterator();
    }

    @Override
    public Iterator<Map.Entry<Long, E>> entryIterator() {
        return Streams.stream(this.keyIterator()).map(k -> Map.entry(k, this.get(k))).iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public long size() {
        return this.index.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.index.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.index.values().stream().map(this.values::getPositioned).anyMatch(value::equals);
    }

    @Override
    public void clear() {
        this.index.clear();
        this.values.clear();
    }
}

