/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.type;

import java.nio.ByteBuffer;
import org.apache.baremaps.data.type.DataType;

public class DoubleArrayDataType
implements DataType<double[]> {
    @Override
    public int size(double[] values) {
        return 4 + values.length * 8;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, double[] values) {
        buffer.putInt(position, this.size(values));
        int p = position + 4;
        for (double value : values) {
            buffer.putDouble(p, value);
            p += 8;
        }
    }

    @Override
    public double[] read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        int length = (size - 4) / 8;
        double[] values = new double[length];
        for (int index = 0; index < length; ++index) {
            values[index] = buffer.getDouble(position + 4 + index * 8);
        }
        return values;
    }
}

