/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DenseFeature;
import org.apache.sis.feature.FeatureFormat;
import org.apache.sis.feature.FeatureType;
import org.apache.sis.feature.FieldType;
import org.apache.sis.feature.NamedFeatureType;
import org.apache.sis.feature.SparseFeature;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;
import org.opengis.util.ScopedName;

public class DefaultFeatureType
extends AbstractIdentifiedType
implements FeatureType {
    private static final long serialVersionUID = -4357370600723922312L;
    private final boolean isAbstract;
    private transient boolean isSimple;
    private transient boolean isSparse;
    private transient boolean isResolved;
    private final Set<DefaultFeatureType> superTypes;
    private transient Set<GenericName> assignableTo;
    private final List<AbstractIdentifiedType> properties;
    private transient Collection<AbstractIdentifiedType> allProperties;
    private transient Map<String, AbstractIdentifiedType> byName;
    private transient Map<String, Integer> indices;
    static final Integer OPERATION_INDEX = -1;

    /*
     * WARNING - void declaration
     */
    public DefaultFeatureType(Map<String, ?> identification, boolean isAbstract, DefaultFeatureType[] superTypes, AbstractIdentifiedType ... properties) {
        super(identification);
        void var6_8;
        ArgumentChecks.ensureNonNull((String)"properties", (Object)properties);
        this.isAbstract = isAbstract;
        if (superTypes == null) {
            this.superTypes = Collections.emptySet();
        } else {
            this.superTypes = CollectionsExt.immutableSet((boolean)true, (Object[])superTypes);
            for (FeatureType featureType : this.superTypes) {
                if (!(featureType instanceof NamedFeatureType)) continue;
                throw new IllegalArgumentException(Resources.format((short)71, featureType.getName()));
            }
        }
        ArrayList<AbstractIdentifiedType> sourceProperties = new ArrayList<AbstractIdentifiedType>(properties.length);
        boolean bl = false;
        while (var6_8 < properties.length) {
            AbstractIdentifiedType property = properties[var6_8];
            ArgumentChecks.ensureNonNullElement((String)"properties", (int)var6_8, (Object)property);
            sourceProperties.add(property);
            ++var6_8;
        }
        this.computeTransientFields(sourceProperties);
        int n = sourceProperties.size();
        switch (n) {
            case 0: {
                this.properties = Collections.emptyList();
                break;
            }
            case 1: {
                this.properties = Collections.singletonList((AbstractIdentifiedType)sourceProperties.get(0));
                break;
            }
            default: {
                this.properties = UnmodifiableArrayList.wrap((Object[])sourceProperties.toArray(new AbstractIdentifiedType[n]));
            }
        }
        for (AbstractIdentifiedType property : this.allProperties) {
            if (!(property instanceof AbstractOperation)) continue;
            for (String dependency : ((AbstractOperation)property).getDependencies()) {
                if (this.byName.containsKey(dependency)) continue;
                throw new IllegalArgumentException(Resources.format((short)18, property.getName(), dependency, super.getName()));
            }
        }
        this.isResolved = this.resolve(this, this.properties, null, this.isSimple);
    }

    @Override
    GenericName createName(NameFactory factory, String value) {
        return factory.createTypeName(null, (CharSequence)value);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.computeTransientFields(this.properties);
        this.isResolved = this.isSimple;
    }

    private void computeTransientFields(List<AbstractIdentifiedType> properties) {
        int capacity = Containers.hashMapCapacity((int)properties.size());
        this.byName = new LinkedHashMap<String, AbstractIdentifiedType>(capacity);
        this.indices = new LinkedHashMap<String, Integer>(capacity);
        this.assignableTo = new HashSet<GenericName>(4);
        this.assignableTo.add(super.getName());
        this.scanPropertiesFrom(this, properties);
        this.allProperties = UnmodifiableArrayList.wrap((Object[])((AbstractIdentifiedType[])this.byName.values().toArray(AbstractIdentifiedType[]::new)));
        this.isSimple = true;
        int index = 0;
        int mandatory = 0;
        for (Map.Entry<String, AbstractIdentifiedType> entry : this.byName.entrySet()) {
            int maximumOccurs;
            int minimumOccurs;
            AbstractIdentifiedType property = entry.getValue();
            if (property instanceof DefaultAttributeType) {
                minimumOccurs = ((DefaultAttributeType)property).getMinimumOccurs();
                this.isSimple &= minimumOccurs == (maximumOccurs = ((DefaultAttributeType)property).getMaximumOccurs());
            } else if (property instanceof FieldType) {
                minimumOccurs = ((FieldType)property).getMinimumOccurs();
                maximumOccurs = ((FieldType)property).getMaximumOccurs();
                this.isSimple = false;
            } else {
                if (!DefaultFeatureType.isParameterlessOperation(property)) continue;
                this.indices.put(entry.getKey(), OPERATION_INDEX);
                continue;
            }
            if (maximumOccurs == 0) continue;
            this.isSimple &= maximumOccurs == 1;
            this.indices.put(entry.getKey(), index++);
            if (minimumOccurs == 0) continue;
            ++mandatory;
        }
        LinkedHashMap<String, AbstractIdentifiedType> aliases = new LinkedHashMap<String, AbstractIdentifiedType>();
        for (AbstractIdentifiedType property : this.allProperties) {
            String key;
            GenericName name = property.getName();
            while (name instanceof ScopedName && name != (name = ((ScopedName)name).tail()) && (key = name.toString()) != null && !(key = key.trim()).isEmpty()) {
                aliases.put(key, aliases.containsKey(key) ? null : property);
            }
        }
        for (Map.Entry entry : aliases.entrySet()) {
            Integer value;
            String tip;
            AbstractIdentifiedType property = (AbstractIdentifiedType)entry.getValue();
            if (property != null && this.byName.putIfAbsent(tip = (String)entry.getKey(), property) == null && (value = this.indices.get(property.getName().toString())) != null && this.indices.put(tip, value) != null) {
                throw new AssertionError((Object)tip);
            }
        }
        this.byName = CollectionsExt.compact(this.byName);
        this.indices = CollectionsExt.compact(this.indices);
        this.assignableTo = CollectionsExt.unmodifiableOrCopy(this.assignableTo);
        int n = this.indices.size();
        this.isSparse = n > 24 && mandatory <= n / 2;
    }

    private void scanPropertiesFrom(DefaultFeatureType source, Collection<? extends AbstractIdentifiedType> sourceProperties) {
        for (DefaultFeatureType parent : source.getSuperTypes()) {
            if (!this.assignableTo.add(parent.getName())) continue;
            this.scanPropertiesFrom(parent, parent.getProperties(false));
        }
        int index = -1;
        Iterator<? extends AbstractIdentifiedType> it = sourceProperties.iterator();
        while (it.hasNext()) {
            AbstractIdentifiedType property = it.next();
            String name = DefaultFeatureType.toString(property.getName(), source, "properties", ++index);
            AbstractIdentifiedType previous = this.byName.put(name, property);
            if (previous == null) continue;
            if (previous.equals(property)) {
                this.byName.put(name, previous);
                if (source != this) continue;
                it.remove();
                continue;
            }
            if (DefaultFeatureType.isAssignableIgnoreName(previous, property)) continue;
            GenericName owner = DefaultFeatureType.ownerOf(this, sourceProperties, previous);
            throw new IllegalArgumentException(Resources.format((short)58, owner != null ? owner : "?", name));
        }
    }

    private static GenericName ownerOf(DefaultFeatureType type, Collection<? extends AbstractIdentifiedType> properties, AbstractIdentifiedType toSearch) {
        if (properties.contains(toSearch)) {
            return type.getName();
        }
        for (DefaultFeatureType superType : type.getSuperTypes()) {
            GenericName owner = DefaultFeatureType.ownerOf(superType, superType.getProperties(false), toSearch);
            if (owner == null) continue;
            return owner;
        }
        return null;
    }

    private boolean resolve(DefaultFeatureType feature, Map<FeatureType, Boolean> previous) {
        feature.isResolved = this.resolve(feature, feature.properties, previous, feature.isResolved);
        return feature.isResolved;
    }

    private boolean resolve(DefaultFeatureType feature, Collection<? extends AbstractIdentifiedType> toUpdate, Map<FeatureType, Boolean> previous, boolean resolved) {
        if (!resolved) {
            resolved = true;
            for (DefaultFeatureType defaultFeatureType : feature.getSuperTypes()) {
                resolved &= this.resolve(defaultFeatureType, previous);
            }
            for (AbstractIdentifiedType abstractIdentifiedType : toUpdate) {
                Boolean r;
                if (!(abstractIdentifiedType instanceof DefaultAssociationRole)) continue;
                if (!((DefaultAssociationRole)abstractIdentifiedType).resolve(this, this.properties)) {
                    resolved = false;
                    continue;
                }
                DefaultFeatureType valueType = ((DefaultAssociationRole)abstractIdentifiedType).getValueType();
                if (valueType == this) continue;
                if (previous == null) {
                    previous = new IdentityHashMap<FeatureType, Boolean>(8);
                }
                if ((r = previous.put(valueType, Boolean.FALSE)) == null) {
                    r = this.resolve(valueType, previous);
                    previous.put(valueType, r);
                }
                resolved &= r.booleanValue();
            }
        }
        return resolved;
    }

    static boolean isParameterlessOperation(AbstractIdentifiedType type) {
        if (type instanceof AbstractOperation) {
            ParameterDescriptorGroup parameters = ((AbstractOperation)type).getParameters();
            return (parameters == null || parameters.descriptors().isEmpty()) && ((AbstractOperation)type).getResult() != null;
        }
        return false;
    }

    public final boolean isAbstract() {
        return this.isAbstract;
    }

    final boolean isSparse() {
        return this.isSparse;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    static boolean maybeAssignableFrom(DefaultFeatureType base, DefaultFeatureType type) {
        return type.assignableTo.contains(base.getName());
    }

    @Override
    public boolean isAssignableFrom(DefaultFeatureType type) {
        if (type == this) {
            return true;
        }
        ArgumentChecks.ensureNonNull((String)"type", (Object)type);
        if (!DefaultFeatureType.maybeAssignableFrom(this, type)) {
            return false;
        }
        for (Map.Entry<String, AbstractIdentifiedType> entry : this.byName.entrySet()) {
            AbstractIdentifiedType other;
            try {
                other = type.getProperty(entry.getKey());
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            if (DefaultFeatureType.isAssignableIgnoreName(entry.getValue(), other)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAssignableIgnoreName(AbstractIdentifiedType base, AbstractIdentifiedType other) {
        AbstractIdentifiedType r1;
        int maxOccurs;
        int minOccurs;
        FieldType p1;
        AbstractIdentifiedType p0;
        if (base == other) return true;
        if (base instanceof DefaultAttributeType) {
            p0 = (DefaultAttributeType)base;
            if (other instanceof DefaultAttributeType) {
                p1 = (DefaultAttributeType)other;
            } else {
                if (!DefaultFeatureType.isParameterlessOperation(other)) return false;
                AbstractIdentifiedType result = ((AbstractOperation)other).getResult();
                if (!(result instanceof DefaultAttributeType)) return false;
                p1 = (DefaultAttributeType)result;
            }
            if (!((DefaultAttributeType)p0).getValueClass().isAssignableFrom(((DefaultAttributeType)p1).getValueClass()) || (minOccurs = ((DefaultAttributeType)p0).getMinimumOccurs()) > ((DefaultAttributeType)p1).getMinimumOccurs() || (maxOccurs = ((DefaultAttributeType)p0).getMaximumOccurs()) < ((DefaultAttributeType)p1).getMaximumOccurs() || p1 != other && (minOccurs > 1 || maxOccurs < 1)) {
                return false;
            }
        }
        if (base instanceof DefaultAssociationRole) {
            DefaultFeatureType f1;
            p0 = (DefaultAssociationRole)base;
            if (other instanceof DefaultAssociationRole) {
                p1 = (DefaultAssociationRole)other;
            } else {
                if (!DefaultFeatureType.isParameterlessOperation(other)) return false;
                AbstractIdentifiedType result = ((AbstractOperation)other).getResult();
                if (!(result instanceof DefaultAssociationRole)) return false;
                p1 = (DefaultAssociationRole)result;
            }
            minOccurs = ((DefaultAssociationRole)p0).getMinimumOccurs();
            if (minOccurs > ((DefaultAssociationRole)p1).getMinimumOccurs() || (maxOccurs = ((DefaultAssociationRole)p0).getMaximumOccurs()) < ((DefaultAssociationRole)p1).getMaximumOccurs() || p1 != other && (minOccurs > 1 || maxOccurs < 1)) {
                return false;
            }
            DefaultFeatureType f0 = ((DefaultAssociationRole)p0).getValueType();
            if (f0 != (f1 = ((DefaultAssociationRole)p1).getValueType()) && !f0.isAssignableFrom(f1)) {
                return false;
            }
        }
        if (!(base instanceof AbstractOperation)) return true;
        p0 = (AbstractOperation)base;
        if (other instanceof AbstractOperation) {
            AbstractOperation p12 = (AbstractOperation)other;
            if (!Objects.equals(((AbstractOperation)p0).getParameters(), p12.getParameters())) {
                return false;
            }
            r1 = p12.getResult();
        } else {
            if (!DefaultFeatureType.isParameterlessOperation(base)) return false;
            r1 = other;
        }
        AbstractIdentifiedType r0 = ((AbstractOperation)p0).getResult();
        if (r0 == r1 || !(r0 instanceof DefaultFeatureType ? !(r1 instanceof DefaultFeatureType) || !((FeatureType)((Object)r0)).isAssignableFrom((DefaultFeatureType)r1) : r0 != null && (r1 == null || !DefaultFeatureType.isAssignableIgnoreName(r0, r1)))) return true;
        return false;
    }

    public final Set<DefaultFeatureType> getSuperTypes() {
        return this.superTypes;
    }

    @Override
    public Collection<AbstractIdentifiedType> getProperties(boolean includeSuperTypes) {
        return includeSuperTypes ? this.allProperties : this.properties;
    }

    public AbstractIdentifiedType getProperty(String name) throws IllegalArgumentException {
        AbstractIdentifiedType pt = this.byName.get(name);
        if (pt != null) {
            return pt;
        }
        throw new IllegalArgumentException(AbstractFeature.propertyNotFound(this, this.getName(), name));
    }

    final Map<String, Integer> indices() {
        return this.indices;
    }

    public AbstractFeature newInstance() throws IllegalStateException {
        if (this.isAbstract) {
            throw new IllegalStateException(Resources.format((short)1, this.getName()));
        }
        return this.isSparse ? new SparseFeature(this) : new DenseFeature(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.superTypes.hashCode() + 37 * this.properties.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (super.equals(obj)) {
            DefaultFeatureType that = (DefaultFeatureType)obj;
            return this.isAbstract == that.isAbstract && this.superTypes.equals(that.superTypes) && this.properties.equals(that.properties);
        }
        return false;
    }

    public String toString() {
        return FeatureFormat.sharedFormat(this);
    }
}

