/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mil.nga.geopackage.contents.Contents;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.db.table.Constraint;
import mil.nga.geopackage.db.table.ConstraintType;
import mil.nga.geopackage.db.table.Constraints;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserColumns;

public abstract class UserTable<TColumn extends UserColumn> {
    public static boolean DEFAULT_AUTOINCREMENT = true;
    public static boolean DEFAULT_PK_NOT_NULL = true;
    private UserColumns<TColumn> columns;
    private final Constraints constraints;
    private Contents contents;

    protected UserTable(UserColumns<TColumn> columns) {
        this.columns = columns;
        this.constraints = new Constraints();
    }

    protected UserTable(UserTable<TColumn> userTable) {
        this.columns = userTable.columns.copy();
        this.constraints = userTable.constraints.copy();
        this.contents = userTable.contents;
    }

    public abstract UserTable<TColumn> copy();

    public abstract String getDataType();

    protected String getDataType(String defaultType) {
        String dataType = null;
        if (this.contents != null) {
            dataType = this.contents.getDataTypeName();
        }
        if (dataType == null) {
            dataType = defaultType;
        }
        return dataType;
    }

    public abstract UserColumns<TColumn> createUserColumns(List<TColumn> var1);

    public UserColumns<TColumn> createUserColumns(String[] columnNames) {
        return this.createUserColumns(this.getColumns(columnNames));
    }

    public UserColumns<TColumn> getUserColumns() {
        return this.columns;
    }

    public int getColumnIndex(String columnName) {
        return this.columns.getColumnIndex(columnName);
    }

    public String[] getColumnNames() {
        return this.columns.getColumnNames();
    }

    public String getColumnName(int index) {
        return this.columns.getColumnName(index);
    }

    public List<TColumn> getColumns() {
        return this.columns.getColumns();
    }

    public List<TColumn> getColumns(String[] columnNames) {
        ArrayList<TColumn> columns = new ArrayList<TColumn>();
        for (String columnName : columnNames) {
            columns.add(this.getColumn(columnName));
        }
        return columns;
    }

    public TColumn getColumn(int index) {
        return this.columns.getColumn(index);
    }

    public TColumn getColumn(String columnName) {
        return this.columns.getColumn(columnName);
    }

    public boolean hasColumn(String columnName) {
        return this.columns.hasColumn(columnName);
    }

    public int columnCount() {
        return this.columns.columnCount();
    }

    public String getTableName() {
        return this.columns.getTableName();
    }

    public void setTableName(String tableName) {
        this.columns.setTableName(tableName);
    }

    public boolean hasPkColumn() {
        return this.columns.hasPkColumn();
    }

    public int getPkColumnIndex() {
        return this.columns.getPkColumnIndex();
    }

    public TColumn getPkColumn() {
        return this.columns.getPkColumn();
    }

    public String getPkColumnName() {
        return this.columns.getPkColumnName();
    }

    public void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
    }

    public void addConstraints(Collection<Constraint> constraints) {
        this.constraints.add(constraints);
    }

    public void addConstraints(Constraints constraints) {
        this.addConstraints(constraints.all());
    }

    public boolean hasConstraints() {
        return this.constraints.has();
    }

    public boolean hasConstraints(ConstraintType type) {
        return this.constraints.has(type);
    }

    public Constraints getConstraints() {
        return this.constraints;
    }

    public List<Constraint> getConstraints(ConstraintType type) {
        return this.constraints.get(type);
    }

    public List<Constraint> clearConstraints() {
        return this.constraints.clear();
    }

    public List<Constraint> clearConstraints(ConstraintType type) {
        return this.constraints.clear(type);
    }

    public List<TColumn> columnsOfType(GeoPackageDataType type) {
        return this.columns.columnsOfType(type);
    }

    public Contents getContents() {
        return this.contents;
    }

    public void setContents(Contents contents) {
        this.contents = contents;
        if (contents != null) {
            this.validateContents(contents);
        }
    }

    protected void validateContents(Contents contents) {
    }

    public boolean isPkModifiable() {
        return this.columns.isPkModifiable();
    }

    public void setPkModifiable(boolean pkModifiable) {
        this.columns.setPkModifiable(pkModifiable);
    }

    public boolean isValueValidation() {
        return this.columns.isValueValidation();
    }

    public void setValueValidation(boolean valueValidation) {
        this.columns.setValueValidation(valueValidation);
    }

    public void addColumn(TColumn column) {
        this.columns.addColumn(column);
    }

    public void renameColumn(TColumn column, String newColumnName) {
        this.columns.renameColumn(column, newColumnName);
    }

    public void renameColumn(String columnName, String newColumnName) {
        this.columns.renameColumn(columnName, newColumnName);
    }

    public void renameColumn(int index, String newColumnName) {
        this.columns.renameColumn(index, newColumnName);
    }

    public void dropColumn(TColumn column) {
        this.columns.dropColumn(column);
    }

    public void dropColumn(String columnName) {
        this.columns.dropColumn(columnName);
    }

    public void dropColumn(int index) {
        this.columns.dropColumn(index);
    }

    public void alterColumn(TColumn column) {
        this.columns.alterColumn(column);
    }

    public boolean hasSchema() {
        return this.columns != null && this.columns.hasSchema();
    }
}

