/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.postgres.store;

import de.bytefish.pgbulkinsert.pgsql.handlers.BaseValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.DoubleValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.FloatValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.Inet4AddressValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.Inet6AddressValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IntegerValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.JsonbValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateTimeValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalTimeValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LongValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ShortValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.StringValueHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.baremaps.postgres.copy.CopyWriter;
import org.apache.baremaps.postgres.copy.EnvelopeValueHandler;
import org.apache.baremaps.postgres.copy.GeometryValueHandler;
import org.apache.baremaps.postgres.metadata.DatabaseMetadata;
import org.apache.baremaps.postgres.metadata.TableMetadata;
import org.apache.baremaps.postgres.store.PostgresDataTable;
import org.apache.baremaps.postgres.store.PostgresTypeConversion;
import org.apache.baremaps.store.DataColumn;
import org.apache.baremaps.store.DataColumnFixed;
import org.apache.baremaps.store.DataRow;
import org.apache.baremaps.store.DataSchema;
import org.apache.baremaps.store.DataSchemaImpl;
import org.apache.baremaps.store.DataStore;
import org.apache.baremaps.store.DataStoreException;
import org.apache.baremaps.store.DataTable;
import org.postgresql.PGConnection;
import org.postgresql.copy.PGCopyOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresDataStore
implements DataStore {
    public static final String REGEX = "[^a-zA-Z0-9]";
    private static final Logger logger = LoggerFactory.getLogger(PostgresDataStore.class);
    private static final String[] TYPES = new String[]{"TABLE", "VIEW"};
    private final DataSource dataSource;

    public PostgresDataStore(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public List<String> list() throws DataStoreException {
        try {
            DatabaseMetadata metadata = new DatabaseMetadata(this.dataSource);
            return metadata.getTableMetaData(null, "public", null, TYPES).stream().map(table -> table.table().tableName()).toList();
        }
        catch (SQLException e) {
            throw new DataStoreException((Throwable)e);
        }
    }

    public DataTable get(String name) throws DataStoreException {
        try {
            DatabaseMetadata databaseMetadata = new DatabaseMetadata(this.dataSource);
            String postgresName = name.replaceAll(REGEX, "_").toLowerCase();
            Optional tableMetadata = databaseMetadata.getTableMetaData(null, null, postgresName, TYPES).stream().findFirst();
            if (tableMetadata.isEmpty()) {
                throw new DataStoreException("Table " + name + " does not exist.");
            }
            DataSchema schema = PostgresDataStore.createSchema((TableMetadata)tableMetadata.get());
            return new PostgresDataTable(this.dataSource, schema);
        }
        catch (SQLException e) {
            throw new DataStoreException((Throwable)e);
        }
    }

    public void add(DataTable table) {
        String name = table.schema().name().replaceAll(REGEX, "_").toLowerCase();
        this.add(name, table);
    }

    public void add(String name, DataTable table) {
        try (Connection connection = this.dataSource.getConnection();){
            HashMap<String, String> mapping = new HashMap<String, String>();
            ArrayList<DataColumnFixed> properties = new ArrayList<DataColumnFixed>();
            for (DataColumn column : table.schema().columns()) {
                if (!PostgresTypeConversion.typeToName.containsKey(column.type())) continue;
                String columnName = column.name().replaceAll(REGEX, "_").toLowerCase();
                mapping.put(columnName, column.name());
                properties.add(new DataColumnFixed(columnName, column.cardinality(), column.type()));
            }
            DataSchemaImpl schema = new DataSchemaImpl(name, properties);
            String createQuery = this.createTable((DataSchema)schema);
            logger.debug(createQuery);
            try (PreparedStatement createStatement = connection.prepareStatement(createQuery);){
                createStatement.execute();
            }
            String truncateQuery = this.truncateTable((DataSchema)schema);
            logger.debug(truncateQuery);
            try (PreparedStatement truncateStatement = connection.prepareStatement(truncateQuery);){
                truncateStatement.execute();
            }
            PGConnection pgConnection = connection.unwrap(PGConnection.class);
            String copyQuery = this.copy((DataSchema)schema);
            logger.debug(copyQuery);
            try (CopyWriter writer = new CopyWriter(new PGCopyOutputStream(pgConnection, copyQuery));){
                writer.writeHeader();
                List<DataColumn> columns = this.getColumns((DataSchema)schema);
                List<BaseValueHandler> handlers = this.getHandlers((DataSchema)schema);
                for (DataRow row : table) {
                    writer.startRow(columns.size());
                    for (int i = 0; i < columns.size(); ++i) {
                        String targetColumn = columns.get(i).name();
                        String sourceColumn = (String)mapping.get(targetColumn);
                        Object value = row.get(sourceColumn);
                        if (value == null) {
                            writer.writeNull();
                            continue;
                        }
                        BaseValueHandler handler = handlers.get(i);
                        writer.write(handler, value);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DataStoreException((Throwable)e);
        }
    }

    public void remove(String name) {
        DataSchema schema = this.get(name).schema();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.dropTable(schema));){
            statement.execute();
        }
        catch (SQLException e) {
            throw new DataStoreException((Throwable)e);
        }
    }

    protected static DataSchema createSchema(TableMetadata tableMetadata) {
        String name = tableMetadata.table().tableName();
        List<DataColumn> columns = tableMetadata.columns().stream().map(column -> new DataColumnFixed(column.columnName(), column.isNullable().equals("NO") ? DataColumn.Cardinality.REQUIRED : DataColumn.Cardinality.OPTIONAL, PostgresTypeConversion.nameToType.get(column.typeName()))).map(DataColumn.class::cast).toList();
        return new DataSchemaImpl(name, columns);
    }

    protected String dropTable(DataSchema schema) {
        return String.format("DROP TABLE IF EXISTS \"%s\" CASCADE", schema.name());
    }

    protected String truncateTable(DataSchema schema) {
        return String.format("TRUNCATE TABLE \"%s\" CASCADE", schema.name());
    }

    protected String createTable(DataSchema schema) {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE IF NOT EXISTS \"");
        builder.append(schema.name());
        builder.append("\" (");
        builder.append(schema.columns().stream().map(PostgresDataStore::getColumnType).collect(Collectors.joining(", ")));
        builder.append(")");
        return builder.toString();
    }

    private static String getColumnType(DataColumn column) {
        String columnName = column.name();
        String columnType = PostgresTypeConversion.typeToName.get(column.type());
        String columnArray = column.cardinality() == DataColumn.Cardinality.REPEATED ? "[]" : "";
        String columnNull = column.cardinality() == DataColumn.Cardinality.REQUIRED ? "NOT NULL" : "";
        return String.format("\"%s\" %s%s %s", columnName, columnType, columnArray, columnNull).strip();
    }

    protected String copy(DataSchema schema) {
        StringBuilder builder = new StringBuilder();
        builder.append("COPY \"");
        builder.append(schema.name());
        builder.append("\" (");
        builder.append(schema.columns().stream().map(column -> "\"" + column.name() + "\"").collect(Collectors.joining(", ")));
        builder.append(") FROM STDIN BINARY");
        return builder.toString();
    }

    protected List<DataColumn> getColumns(DataSchema schema) {
        return schema.columns().stream().filter(this::isSupported).toList();
    }

    protected List<BaseValueHandler> getHandlers(DataSchema schema) {
        return this.getColumns(schema).stream().map(column -> this.getHandler(column.type())).toList();
    }

    protected BaseValueHandler getHandler(DataColumn.Type type) {
        return switch (type) {
            case DataColumn.Type.STRING -> new StringValueHandler();
            case DataColumn.Type.SHORT -> new ShortValueHandler();
            case DataColumn.Type.INTEGER -> new IntegerValueHandler();
            case DataColumn.Type.LONG -> new LongValueHandler();
            case DataColumn.Type.FLOAT -> new FloatValueHandler();
            case DataColumn.Type.DOUBLE -> new DoubleValueHandler();
            case DataColumn.Type.INET4_ADDRESS -> new Inet4AddressValueHandler();
            case DataColumn.Type.INET6_ADDRESS -> new Inet6AddressValueHandler();
            case DataColumn.Type.LOCAL_DATE -> new LocalDateValueHandler();
            case DataColumn.Type.LOCAL_TIME -> new LocalTimeValueHandler();
            case DataColumn.Type.LOCAL_DATE_TIME -> new LocalDateTimeValueHandler();
            case DataColumn.Type.GEOMETRY, DataColumn.Type.POINT, DataColumn.Type.MULTIPOINT, DataColumn.Type.LINESTRING, DataColumn.Type.MULTILINESTRING, DataColumn.Type.POLYGON, DataColumn.Type.MULTIPOLYGON, DataColumn.Type.GEOMETRYCOLLECTION -> new GeometryValueHandler();
            case DataColumn.Type.ENVELOPE -> new EnvelopeValueHandler();
            case DataColumn.Type.NESTED -> new JsonbValueHandler();
            default -> throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
        };
    }

    protected boolean isSupported(DataColumn column) {
        return PostgresTypeConversion.typeToName.containsKey(column.type());
    }
}

