/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.store;

import java.util.List;
import org.apache.baremaps.store.DataColumn;
import org.apache.baremaps.store.DataRow;
import org.apache.baremaps.store.DataSchema;

public record DataRowImpl(DataSchema schema, List<Object> values) implements DataRow
{
    @Override
    public Object get(String column) {
        List<DataColumn> columns = this.schema.columns();
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.get(i).name().equals(column)) continue;
            return this.values.get(i);
        }
        throw new IllegalArgumentException("Column " + column + " not found.");
    }

    @Override
    public Object get(int index) {
        return this.values.get(index);
    }

    @Override
    public void set(String column, Object value) {
        for (int i = 0; i < this.schema.columns().size(); ++i) {
            if (!this.schema.columns().get(i).name().equals(column)) continue;
            this.values.set(i, value);
            return;
        }
        throw new IllegalArgumentException("Column " + column + " not found.");
    }

    @Override
    public void set(int index, Object value) {
        this.values.set(index, value);
    }
}

