/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.endpoint;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.ReentrantLock;

public class WeightedRandomDistributionSelector<T extends AbstractEntry> {
    private final ReentrantLock lock = new ReentrantShortLock();
    private final List<T> allEntries;
    @GuardedBy(value="lock")
    private final List<T> currentEntries;
    private final long total;
    private long remaining;

    public WeightedRandomDistributionSelector(List<T> endpoints) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(endpoints.size());
        long total = 0L;
        for (AbstractEntry entry : endpoints) {
            if (entry.weight() <= 0) continue;
            builder.add(entry);
            total += (long)entry.weight();
        }
        this.total = total;
        this.remaining = total;
        this.allEntries = builder.build();
        this.currentEntries = new ArrayList<T>(this.allEntries);
    }

    public List<T> entries() {
        return this.allEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T select() {
        if (this.allEntries.isEmpty()) {
            return null;
        }
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        this.lock.lock();
        try {
            long target = threadLocalRandom.nextLong(this.remaining);
            Iterator<T> it = this.currentEntries.iterator();
            while (it.hasNext()) {
                AbstractEntry entry = (AbstractEntry)it.next();
                int weight = entry.weight();
                if ((target -= (long)weight) >= 0L) continue;
                entry.increment();
                if (entry.isFull()) {
                    it.remove();
                    entry.reset();
                    this.remaining -= (long)weight;
                    if (this.remaining == 0L) {
                        this.currentEntries.addAll(this.allEntries);
                        this.remaining = this.total;
                    } else assert (this.remaining > 0L) : this.remaining;
                }
                AbstractEntry abstractEntry = entry;
                return (T)abstractEntry;
            }
        }
        finally {
            this.lock.unlock();
        }
        throw new Error("Should never reach here");
    }

    public static abstract class AbstractEntry {
        private int counter;

        public final void increment() {
            assert (this.counter < this.weight());
            ++this.counter;
        }

        public abstract int weight();

        public final void reset() {
            this.counter = 0;
        }

        public final int counter() {
            return this.counter;
        }

        public final boolean isFull() {
            return this.counter >= this.weight();
        }
    }
}

