/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.credential.CredentialProvider;
import org.apache.gravitino.credential.CredentialProviderFactory;
import org.apache.gravitino.credential.CredentialProviderManager;
import org.apache.gravitino.iceberg.common.IcebergConfig;
import org.apache.gravitino.iceberg.common.ops.IcebergCatalogWrapper;
import org.apache.gravitino.iceberg.service.IcebergRestUtils;
import org.apache.gravitino.iceberg.service.provider.IcebergConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergCatalogWrapperManager
implements AutoCloseable {
    public static final Logger LOG = LoggerFactory.getLogger(IcebergCatalogWrapperManager.class);
    private final Cache<String, IcebergCatalogWrapper> icebergCatalogWrapperCache;
    private final IcebergConfigProvider configProvider;
    private CredentialProviderManager credentialProviderManager = new CredentialProviderManager();

    public IcebergCatalogWrapperManager(Map<String, String> properties, IcebergConfigProvider configProvider) {
        this.configProvider = configProvider;
        this.icebergCatalogWrapperCache = Caffeine.newBuilder().expireAfterWrite(((Long)new IcebergConfig(properties).get(IcebergConfig.ICEBERG_REST_CATALOG_CACHE_EVICTION_INTERVAL)).longValue(), TimeUnit.MILLISECONDS).removalListener((k, v, c) -> {
            String catalogName = (String)k;
            LOG.info("Remove IcebergCatalogWrapper cache {}.", (Object)catalogName);
            this.closeIcebergCatalogWrapper((IcebergCatalogWrapper)v);
            this.credentialProviderManager.unregisterCredentialProvider(catalogName);
        }).scheduler(Scheduler.forScheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("iceberg-catalog-wrapper-cleaner-%d").build()))).build();
    }

    public IcebergCatalogWrapper getOps(String rawPrefix) {
        String catalogName = IcebergRestUtils.getCatalogName(rawPrefix);
        return this.getCatalogWrapper(catalogName);
    }

    public IcebergCatalogWrapper getCatalogWrapper(String catalogName) {
        IcebergCatalogWrapper catalogWrapper = (IcebergCatalogWrapper)this.icebergCatalogWrapperCache.get((Object)catalogName, k -> this.createCatalogWrapper(catalogName));
        catalogWrapper.reloadHadoopConf();
        return catalogWrapper;
    }

    public CredentialProvider getCredentialProvider(String catalogName) {
        return this.credentialProviderManager.getCredentialProvider(catalogName);
    }

    @VisibleForTesting
    protected IcebergCatalogWrapper createIcebergCatalogWrapper(IcebergConfig icebergConfig) {
        return new IcebergCatalogWrapper(icebergConfig);
    }

    private IcebergCatalogWrapper createCatalogWrapper(String catalogName) {
        Optional<IcebergConfig> icebergConfig = this.configProvider.getIcebergCatalogConfig(catalogName);
        if (!icebergConfig.isPresent()) {
            throw new RuntimeException("Couldn't find Iceberg configuration for " + catalogName);
        }
        IcebergConfig config = icebergConfig.get();
        String credentialProviderType = (String)config.get(IcebergConfig.CREDENTIAL_PROVIDER_TYPE);
        if (StringUtils.isNotBlank((CharSequence)credentialProviderType)) {
            CredentialProvider credentialProvider = CredentialProviderFactory.create((String)credentialProviderType, (Map)config.getAllConfig());
            this.credentialProviderManager.registerCredentialProvider(catalogName, credentialProvider);
        }
        return this.createIcebergCatalogWrapper(icebergConfig.get());
    }

    private void closeIcebergCatalogWrapper(IcebergCatalogWrapper catalogWrapper) {
        try {
            catalogWrapper.close();
        }
        catch (Exception ex) {
            LOG.warn("Close Iceberg table catalog wrapper fail: {}, {}", (Object)catalogWrapper, (Object)ex);
        }
    }

    @Override
    public void close() throws Exception {
        this.icebergCatalogWrapperCache.invalidateAll();
    }
}

