/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet;

import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.paimon.format.FileFormatFactory;
import org.apache.paimon.format.parquet.ParquetFileFormat;
import org.apache.paimon.options.Options;
import org.apache.paimon.shade.org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class ParquetFileFormatFactory
implements FileFormatFactory {
    public static final String IDENTIFIER = "parquet";

    public String identifier() {
        return IDENTIFIER;
    }

    public ParquetFileFormat create(FileFormatFactory.FormatContext formatContext) {
        return new ParquetFileFormat(new FileFormatFactory.FormatContext(this.supplyDefaultOptions(formatContext.formatOptions()), formatContext.readBatchSize()));
    }

    private Options supplyDefaultOptions(Options options) {
        String compression = "parquet.compression".replaceFirst(String.format("^%s.", IDENTIFIER), "");
        if (!options.containsKey(compression)) {
            Properties properties = new Properties();
            options.addAllToProperties(properties);
            properties.setProperty(compression, CompressionCodecName.SNAPPY.name());
            Options newOptions = new Options();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> newOptions.setString(k.toString(), v.toString())));
            return newOptions;
        }
        return options;
    }
}

