/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.authorization.AuthorizationMetadataObject;
import org.apache.gravitino.authorization.AuthorizationPrivilege;
import org.apache.gravitino.authorization.AuthorizationPrivilegesMappingProvider;
import org.apache.gravitino.authorization.AuthorizationSecurableObject;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.jdbc.JdbcPrivilege;
import org.apache.gravitino.authorization.jdbc.JdbcSecurableObject;

public class JdbcSecurableObjectMappingProvider
implements AuthorizationPrivilegesMappingProvider {
    private final Map<Privilege.Name, Set<AuthorizationPrivilege>> privilegeMapping = ImmutableMap.of((Object)Privilege.Name.CREATE_TABLE, (Object)Sets.newHashSet((Object[])new AuthorizationPrivilege[]{JdbcPrivilege.CREATE}), (Object)Privilege.Name.CREATE_SCHEMA, (Object)Sets.newHashSet((Object[])new AuthorizationPrivilege[]{JdbcPrivilege.CREATE}), (Object)Privilege.Name.SELECT_TABLE, (Object)Sets.newHashSet((Object[])new AuthorizationPrivilege[]{JdbcPrivilege.SELECT}), (Object)Privilege.Name.MODIFY_TABLE, (Object)Sets.newHashSet((Object[])new AuthorizationPrivilege[]{JdbcPrivilege.SELECT, JdbcPrivilege.UPDATE, JdbcPrivilege.DELETE, JdbcPrivilege.INSERT, JdbcPrivilege.ALTER}), (Object)Privilege.Name.USE_SCHEMA, (Object)Sets.newHashSet((Object[])new AuthorizationPrivilege[]{JdbcPrivilege.USAGE}));
    private final Map<Privilege.Name, MetadataObject.Type> privilegeScopeMapping = ImmutableMap.of((Object)Privilege.Name.CREATE_TABLE, (Object)MetadataObject.Type.TABLE, (Object)Privilege.Name.CREATE_SCHEMA, (Object)MetadataObject.Type.SCHEMA, (Object)Privilege.Name.SELECT_TABLE, (Object)MetadataObject.Type.TABLE, (Object)Privilege.Name.MODIFY_TABLE, (Object)MetadataObject.Type.TABLE, (Object)Privilege.Name.USE_SCHEMA, (Object)MetadataObject.Type.SCHEMA);
    private final Set<AuthorizationPrivilege> ownerPrivileges = ImmutableSet.of();
    private final Set<MetadataObject.Type> allowObjectTypes = ImmutableSet.of((Object)MetadataObject.Type.METALAKE, (Object)MetadataObject.Type.CATALOG, (Object)MetadataObject.Type.SCHEMA, (Object)MetadataObject.Type.TABLE);

    public Map<Privilege.Name, Set<AuthorizationPrivilege>> privilegesMappingRule() {
        return this.privilegeMapping;
    }

    public Set<AuthorizationPrivilege> ownerMappingRule() {
        return this.ownerPrivileges;
    }

    public Set<Privilege.Name> allowPrivilegesRule() {
        return this.privilegeMapping.keySet();
    }

    public Set<MetadataObject.Type> allowMetadataObjectTypesRule() {
        return this.allowObjectTypes;
    }

    public List<AuthorizationSecurableObject> translatePrivilege(SecurableObject securableObject) {
        ArrayList authObjects = Lists.newArrayList();
        ArrayList databasePrivileges = Lists.newArrayList();
        ArrayList tablePrivileges = Lists.newArrayList();
        switch (securableObject.type()) {
            case METALAKE: 
            case CATALOG: {
                this.convertJdbcPrivileges(securableObject, databasePrivileges, tablePrivileges);
                if (!databasePrivileges.isEmpty()) {
                    JdbcSecurableObject databaseObject = JdbcSecurableObject.create("*", null, databasePrivileges);
                    authObjects.add(databaseObject);
                }
                if (tablePrivileges.isEmpty()) break;
                JdbcSecurableObject tableObject = JdbcSecurableObject.create("*", "*", tablePrivileges);
                authObjects.add(tableObject);
                break;
            }
            case SCHEMA: {
                this.convertJdbcPrivileges(securableObject, databasePrivileges, tablePrivileges);
                if (!databasePrivileges.isEmpty()) {
                    JdbcSecurableObject databaseObject = JdbcSecurableObject.create(securableObject.name(), null, databasePrivileges);
                    authObjects.add(databaseObject);
                }
                if (tablePrivileges.isEmpty()) break;
                JdbcSecurableObject tableObject = JdbcSecurableObject.create(securableObject.name(), "*", tablePrivileges);
                authObjects.add(tableObject);
                break;
            }
            case TABLE: {
                this.convertJdbcPrivileges(securableObject, databasePrivileges, tablePrivileges);
                if (tablePrivileges.isEmpty()) break;
                MetadataObject metadataObject = MetadataObjects.parse((String)securableObject.parent(), (MetadataObject.Type)MetadataObject.Type.SCHEMA);
                JdbcSecurableObject tableObject = JdbcSecurableObject.create(metadataObject.name(), securableObject.name(), tablePrivileges);
                authObjects.add(tableObject);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Don't support metadata object type %s", securableObject.type()));
            }
        }
        return authObjects;
    }

    public List<AuthorizationSecurableObject> translateOwner(MetadataObject metadataObject) {
        ArrayList objects = Lists.newArrayList();
        switch (metadataObject.type()) {
            case METALAKE: 
            case CATALOG: {
                objects.add(JdbcSecurableObject.create("*", null, Lists.newArrayList((Object[])new AuthorizationPrivilege[]{JdbcPrivilege.ALL})));
                objects.add(JdbcSecurableObject.create("*", "*", Lists.newArrayList((Object[])new AuthorizationPrivilege[]{JdbcPrivilege.ALL})));
                break;
            }
            case SCHEMA: {
                objects.add(JdbcSecurableObject.create(metadataObject.name(), null, Lists.newArrayList((Object[])new AuthorizationPrivilege[]{JdbcPrivilege.ALL})));
                objects.add(JdbcSecurableObject.create(metadataObject.name(), "*", Lists.newArrayList((Object[])new AuthorizationPrivilege[]{JdbcPrivilege.ALL})));
                break;
            }
            case TABLE: {
                MetadataObject schema = MetadataObjects.parse((String)metadataObject.parent(), (MetadataObject.Type)MetadataObject.Type.SCHEMA);
                objects.add(JdbcSecurableObject.create(schema.name(), metadataObject.name(), Lists.newArrayList((Object[])new AuthorizationPrivilege[]{JdbcPrivilege.ALL})));
                break;
            }
            default: {
                throw new IllegalArgumentException("Don't support metadata object type " + metadataObject.type());
            }
        }
        return objects;
    }

    public List<AuthorizationMetadataObject> translateMetadataObject(MetadataObject metadataObject) {
        throw new UnsupportedOperationException("Not supported");
    }

    private void convertJdbcPrivileges(SecurableObject securableObject, List<AuthorizationPrivilege> databasePrivileges, List<AuthorizationPrivilege> tablePrivileges) {
        for (Privilege privilege : securableObject.privileges()) {
            if (this.privilegeScopeMapping.get(privilege.name()) == MetadataObject.Type.SCHEMA) {
                databasePrivileges.addAll((Collection<AuthorizationPrivilege>)this.privilegeMapping.get(privilege.name()));
                continue;
            }
            if (this.privilegeScopeMapping.get(privilege.name()) != MetadataObject.Type.TABLE) continue;
            tablePrivileges.addAll((Collection<AuthorizationPrivilege>)this.privilegeMapping.get(privilege.name()));
        }
    }
}

