/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.AbstractStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;

public class ContinuousFromSnapshotFullStartingScanner
extends AbstractStartingScanner {
    public ContinuousFromSnapshotFullStartingScanner(SnapshotManager snapshotManager, long snapshotId) {
        super(snapshotManager);
        this.startingSnapshotId = snapshotId;
    }

    @Override
    public ScanMode startingScanMode() {
        return ScanMode.ALL;
    }

    @Override
    public StartingScanner.Result scan(SnapshotReader snapshotReader) {
        Long earliestSnapshotId = this.snapshotManager.earliestSnapshotId();
        if (earliestSnapshotId == null) {
            return new StartingScanner.NoSnapshot();
        }
        long ceiledSnapshotId = Math.max(this.startingSnapshotId, earliestSnapshotId);
        return StartingScanner.fromPlan(snapshotReader.withMode(ScanMode.ALL).withSnapshot(ceiledSnapshotId).read());
    }
}

