/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import java.util.Arrays;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.dto.requests.TagCreateRequest;
import org.apache.gravitino.dto.requests.TagUpdateRequest;
import org.apache.gravitino.dto.requests.TagUpdatesRequest;
import org.apache.gravitino.dto.requests.TagsAssociateRequest;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.MetadataObjectListResponse;
import org.apache.gravitino.dto.responses.NameListResponse;
import org.apache.gravitino.dto.responses.TagListResponse;
import org.apache.gravitino.dto.responses.TagResponse;
import org.apache.gravitino.dto.tag.MetadataObjectDTO;
import org.apache.gravitino.dto.tag.TagDTO;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.MetadataObjectTagOperations;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.tag.Tag;
import org.apache.gravitino.tag.TagChange;
import org.apache.gravitino.tag.TagDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="metalakes/{metalake}/tags")
public class TagOperations {
    private static final Logger LOG = LoggerFactory.getLogger(TagOperations.class);
    private final TagDispatcher tagDispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public TagOperations(TagDispatcher tagDispatcher) {
        this.tagDispatcher = tagDispatcher;
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-tags.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-tags", absolute=true)
    public Response listTags(@PathParam(value="metalake") String metalake, @QueryParam(value="details") @DefaultValue(value="false") boolean verbose) {
        LOG.info("Received list tag {} request for metalake: {}", (Object)(verbose ? "infos" : "names"), (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                if (verbose) {
                    Object[] tags = this.tagDispatcher.listTagsInfo(metalake);
                    TagDTO[] tagDTOs = ArrayUtils.isEmpty((Object[])tags) ? new TagDTO[]{} : (TagDTO[])Arrays.stream(tags).map(t -> DTOConverters.toDTO((Tag)t, Optional.empty())).toArray(TagDTO[]::new);
                    LOG.info("List {} tags info under metalake: {}", (Object)tagDTOs.length, (Object)metalake);
                    return Utils.ok((Object)new TagListResponse(tagDTOs));
                }
                String[] tagNames = this.tagDispatcher.listTags(metalake);
                tagNames = tagNames == null ? new String[]{} : tagNames;
                LOG.info("List {} tags under metalake: {}", (Object)tagNames.length, (Object)metalake);
                return Utils.ok((Object)new NameListResponse(tagNames));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTagException(OperationType.LIST, "", metalake, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="create-tag.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-tag", absolute=true)
    public Response createTag(@PathParam(value="metalake") String metalake, TagCreateRequest request) {
        LOG.info("Received create tag request under metalake: {}", (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                Tag tag = this.tagDispatcher.createTag(metalake, request.getName(), request.getComment(), request.getProperties());
                LOG.info("Created tag: {} under metalake: {}", (Object)tag.name(), (Object)metalake);
                return Utils.ok((Object)new TagResponse(DTOConverters.toDTO((Tag)tag, Optional.empty())));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTagException(OperationType.CREATE, request.getName(), metalake, e);
        }
    }

    @GET
    @Path(value="{tag}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-tag.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-tag", absolute=true)
    public Response getTag(@PathParam(value="metalake") String metalake, @PathParam(value="tag") String name) {
        LOG.info("Received get tag request for tag: {} under metalake: {}", (Object)name, (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                Tag tag = this.tagDispatcher.getTag(metalake, name);
                LOG.info("Get tag: {} under metalake: {}", (Object)name, (Object)metalake);
                return Utils.ok((Object)new TagResponse(DTOConverters.toDTO((Tag)tag, Optional.empty())));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTagException(OperationType.GET, name, metalake, e);
        }
    }

    @PUT
    @Path(value="{tag}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="alter-tag.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="alter-tag", absolute=true)
    public Response alterTag(@PathParam(value="metalake") String metalake, @PathParam(value="tag") String name, TagUpdatesRequest request) {
        LOG.info("Received alter tag request for tag: {} under metalake: {}", (Object)name, (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                TagChange[] changes = (TagChange[])request.getUpdates().stream().map(TagUpdateRequest::tagChange).toArray(TagChange[]::new);
                Tag tag = this.tagDispatcher.alterTag(metalake, name, changes);
                LOG.info("Altered tag: {} under metalake: {}", (Object)name, (Object)metalake);
                return Utils.ok((Object)new TagResponse(DTOConverters.toDTO((Tag)tag, Optional.empty())));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTagException(OperationType.ALTER, name, metalake, e);
        }
    }

    @DELETE
    @Path(value="{tag}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="delete-tag.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="delete-tag", absolute=true)
    public Response deleteTag(@PathParam(value="metalake") String metalake, @PathParam(value="tag") String name) {
        LOG.info("Received delete tag request for tag: {} under metalake: {}", (Object)name, (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                boolean deleted = this.tagDispatcher.deleteTag(metalake, name);
                if (!deleted) {
                    LOG.warn("Failed to delete tag {} under metalake {}", (Object)name, (Object)metalake);
                } else {
                    LOG.info("Deleted tag: {} under metalake: {}", (Object)name, (Object)metalake);
                }
                return Utils.ok((Object)new DropResponse(deleted));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTagException(OperationType.DELETE, name, metalake, e);
        }
    }

    @GET
    @Path(value="{tag}/objects")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-objects-for-tag.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-objects-for-tag", absolute=true)
    public Response listMetadataObjectsForTag(@PathParam(value="metalake") String metalake, @PathParam(value="tag") String tagName) {
        LOG.info("Received list objects for tag: {} under metalake: {}", (Object)tagName, (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                MetadataObject[] objects = this.tagDispatcher.listMetadataObjectsForTag(metalake, tagName);
                objects = objects == null ? new MetadataObject[]{} : objects;
                LOG.info("List {} objects for tag: {} under metalake: {}", new Object[]{objects.length, tagName, metalake});
                MetadataObjectDTO[] objectDTOs = (MetadataObjectDTO[])Arrays.stream(objects).map(DTOConverters::toDTO).toArray(MetadataObjectDTO[]::new);
                return Utils.ok((Object)new MetadataObjectListResponse(objectDTOs));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTagException(OperationType.LIST, "", tagName, e);
        }
    }

    @Deprecated
    @GET
    @Path(value="{type}/{fullName}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-object-tags.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-object-tags", absolute=true)
    public Response listTagsForMetadataObject(@PathParam(value="metalake") String metalake, @PathParam(value="type") String type, @PathParam(value="fullName") String fullName, @QueryParam(value="details") @DefaultValue(value="false") boolean verbose) {
        MetadataObjectTagOperations metadataObjectTagOperations = new MetadataObjectTagOperations(this.tagDispatcher);
        metadataObjectTagOperations.setHttpRequest(this.httpRequest);
        return metadataObjectTagOperations.listTagsForMetadataObject(metalake, type, fullName, verbose);
    }

    @Deprecated
    @GET
    @Path(value="{type}/{fullName}/{tag}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-object-tag.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-object-tag", absolute=true)
    public Response getTagForObject(@PathParam(value="metalake") String metalake, @PathParam(value="type") String type, @PathParam(value="fullName") String fullName, @PathParam(value="tag") String tagName) {
        MetadataObjectTagOperations metadataObjectTagOperations = new MetadataObjectTagOperations(this.tagDispatcher);
        metadataObjectTagOperations.setHttpRequest(this.httpRequest);
        return metadataObjectTagOperations.getTagForObject(metalake, type, fullName, tagName);
    }

    @Deprecated
    @POST
    @Path(value="{type}/{fullName}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="associate-object-tags.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="associate-object-tags", absolute=true)
    public Response associateTagsForObject(@PathParam(value="metalake") String metalake, @PathParam(value="type") String type, @PathParam(value="fullName") String fullName, TagsAssociateRequest request) {
        MetadataObjectTagOperations metadataObjectTagOperations = new MetadataObjectTagOperations(this.tagDispatcher);
        metadataObjectTagOperations.setHttpRequest(this.httpRequest);
        return metadataObjectTagOperations.associateTagsForObject(metalake, type, fullName, request);
    }
}

