/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.gravitino.shaded.com.google.common.collect.Maps;

public class MapUtils {
    private MapUtils() {
    }

    public static Map<String, String> getPrefixMap(Map<String, String> m4, String prefix) {
        HashMap configs = Maps.newHashMap();
        m4.forEach((k, v) -> {
            if (k.startsWith(prefix)) {
                String newKey = k.substring(prefix.length());
                configs.put(newKey, v);
            }
        });
        return Collections.unmodifiableMap(configs);
    }

    public static Map<String, String> getFilteredMap(Map<String, String> m4, Predicate predicate) {
        HashMap configs = Maps.newHashMap();
        m4.forEach((k, v) -> {
            if (predicate.test(k)) {
                configs.put(k, v);
            }
        });
        return Collections.unmodifiableMap(configs);
    }

    public static Map<String, String> unmodifiableMap(Map<String, String> m4) {
        return Collections.unmodifiableMap(m4);
    }
}

