/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

import java.util.Random;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowFlakeIdWorker {
    private static final Logger log = LoggerFactory.getLogger(SnowFlakeIdWorker.class);
    private static final long TW_EPOCH = 1622476800000L;
    private static final long WORKER_ID_BITS = 4L;
    private static final long MAX_WORKER_ID = 15L;
    private static final long SEQUENCE_BITS = 8L;
    private static final long WORKER_ID_SHIFT = 8L;
    private static final long TIMESTAMP_LEFT_SHIFT = 12L;
    private static final long SEQUENCE_MASK = 255L;
    private final long workerId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public SnowFlakeIdWorker(long workerId) {
        if (workerId < 0L || workerId > 15L) {
            Random random = new Random(workerId);
            workerId = random.nextInt(15);
            log.warn("Worker ID can't be greater than {} or less than 0, use random: {}.", (Object)15L, (Object)workerId);
        }
        this.workerId = workerId;
    }

    public SnowFlakeIdWorker() {
        int workerId = 0;
        String host = IpDomainUtil.getLocalhostIp();
        if (host == null) {
            Random random = new Random(workerId);
            workerId = random.nextInt(15);
        } else {
            workerId = host.hashCode() % 15;
            workerId = Math.abs(workerId);
        }
        this.workerId = workerId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1622476800000L << 12 | this.workerId << 8 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }
}

