/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.bind.BindMethod;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.AttributeAccessor;

final class BindMethodAttribute {
    static final String NAME = BindMethod.class.getName();

    private BindMethodAttribute() {
    }

    static BindMethod get(ApplicationContext applicationContext, String beanName) {
        BindMethod bindMethod;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)applicationContext;
            bindMethod = BindMethodAttribute.get(configurableApplicationContext.getBeanFactory(), beanName);
        } else {
            bindMethod = null;
        }
        return bindMethod;
    }

    static BindMethod get(ConfigurableListableBeanFactory beanFactory, String beanName) {
        return !beanFactory.containsBeanDefinition(beanName) ? null : BindMethodAttribute.get((AttributeAccessor)beanFactory.getBeanDefinition(beanName));
    }

    static BindMethod get(BeanDefinitionRegistry beanDefinitionRegistry, String beanName) {
        return !beanDefinitionRegistry.containsBeanDefinition(beanName) ? null : BindMethodAttribute.get((AttributeAccessor)beanDefinitionRegistry.getBeanDefinition(beanName));
    }

    static BindMethod get(AttributeAccessor attributes) {
        return (BindMethod)((Object)attributes.getAttribute(NAME));
    }

    static void set(AttributeAccessor attributes, BindMethod bindMethod) {
        attributes.setAttribute(NAME, (Object)bindMethod);
    }
}

