import React, { useMemo } from "react";
import { WorkflowFormContext } from "./WorkflowFormContext";
import { WorkflowFormGatewayApiImpl } from "./WorkflowFormGatewayApi";
export function WorkflowFormContextProvider(props) {
    const { proxyEndpoint } = props;
    const gatewayApiImpl = useMemo(() => {
        return new WorkflowFormGatewayApiImpl("q/openapi.json", proxyEndpoint);
    }, [proxyEndpoint]);
    return React.createElement(WorkflowFormContext.Provider, { value: gatewayApiImpl }, props.children);
}
export default WorkflowFormContextProvider;
//# sourceMappingURL=WorkflowFormContextProvider.js.map