import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Card, CardBody, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import React from "react";
import { UncontrolledReactSVGPanZoom } from "react-svg-pan-zoom";
import { ReactSvgPanZoomLoader, SvgLoaderSelectElement } from "react-svg-pan-zoom-loader";
const ProcessDiagram = ({ svg, width, height, ouiaId, ouiaSafe }) => {
    return (React.createElement(React.Fragment, null,
        React.createElement(Card, Object.assign({}, componentOuiaProps(ouiaId, "process-diagram", ouiaSafe)),
            React.createElement(CardHeader, null,
                React.createElement(Title, { headingLevel: "h3", size: "xl" }, "Diagram")),
            React.createElement(CardBody, null,
                React.createElement(ReactSvgPanZoomLoader, { src: svg.props.src, width: width !== null && width !== void 0 ? width : 1000, height: height !== null && height !== void 0 ? height : 400, proxy: React.createElement(React.Fragment, null,
                        React.createElement(SvgLoaderSelectElement, null)), render: () => (React.createElement(UncontrolledReactSVGPanZoom, { width: width !== null && width !== void 0 ? width : 1000, height: height !== null && height !== void 0 ? height : 400, detectAutoPan: false, background: "#fff" },
                        React.createElement("svg", { width: width !== null && width !== void 0 ? width : 1000, height: height !== null && height !== void 0 ? height : 400 }, svg))) })))));
};
export default ProcessDiagram;
//# sourceMappingURL=ProcessDiagram.js.map