var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useEffect, useState } from "react";
import get from "lodash/get";
import has from "lodash/has";
import isEmpty from "lodash/isEmpty";
import set from "lodash/set";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import EmptyTaskForm from "../EmptyTaskForm/EmptyTaskForm";
import TaskFormRenderer from "../TaskFormRenderer/TaskFormRenderer";
import { parseTaskSchema } from "../utils/TaskFormDataUtils";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
var State;
(function (State) {
    State[State["READY"] = 0] = "READY";
    State[State["SUBMITTING"] = 1] = "SUBMITTING";
    State[State["SUBMITTED"] = 2] = "SUBMITTED";
})(State || (State = {}));
export const TaskForm = ({ userTask, schema, driver, ouiaId, ouiaSafe }) => {
    const [formData, setFormData] = useState(null);
    const [formState, setFormState] = useState(State.READY);
    const [taskFormSchema, setTaskFormSchema] = useState();
    const [taskFormAssignments, setTaskFormAssignments] = useState();
    useEffect(() => {
        const parsedSchema = parseTaskSchema(schema);
        setTaskFormSchema(parsedSchema.schema);
        setTaskFormAssignments(parsedSchema.assignments);
    }, []);
    if (formState === State.SUBMITTING) {
        return (React.createElement(Bullseye, Object.assign({}, componentOuiaProps((ouiaId ? ouiaId : "task-form") + "-submit-spinner", "task-form", true)),
            React.createElement(KogitoSpinner, { spinnerText: `Submitting for task ${userTask.referenceName} (${userTask.id.substring(0, 5)})` })));
    }
    if (formState === State.READY || formState === State.SUBMITTED) {
        const doSubmit = (phase, data, onSuccess, onFailure) => __awaiter(void 0, void 0, void 0, function* () {
            try {
                setFormState(State.SUBMITTING);
                setFormData(data);
                const payload = {};
                taskFormAssignments.outputs.forEach((output) => {
                    if (has(data, output)) {
                        set(payload, output, get(data, output));
                    }
                });
                const result = yield driver.doSubmit(phase, payload);
                if (onSuccess) {
                    onSuccess(result);
                }
            }
            catch (err) {
                if (onFailure) {
                    onFailure(err);
                }
            }
            finally {
                setFormState(State.SUBMITTED);
            }
        });
        if (!taskFormSchema) {
            return (React.createElement(Bullseye, Object.assign({}, componentOuiaProps((ouiaId ? ouiaId : "task-form-") + "-loading-spinner", "task-form", true)),
                React.createElement(KogitoSpinner, { spinnerText: `Loading task form...` })));
        }
        if (isEmpty(taskFormSchema.properties)) {
            return (React.createElement(EmptyTaskForm, Object.assign({}, componentOuiaProps((ouiaId ? ouiaId : "task-form") + "-empty-form", "task-form", ouiaSafe), { userTask: userTask, enabled: formState == State.READY, formSchema: taskFormSchema, submit: (phase) => doSubmit(phase, {}) })));
        }
        return (React.createElement(TaskFormRenderer, Object.assign({}, componentOuiaProps((ouiaId ? ouiaId : "task-form") + "-form-renderer", "task-form", ouiaSafe), { userTask: userTask, formSchema: taskFormSchema, formData: formData, enabled: formState == State.READY, submit: doSubmit })));
    }
    return null;
};
export default TaskForm;
//# sourceMappingURL=TaskForm.js.map