"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttributesTableRow = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var Label_1 = require("@patternfly/react-core/dist/js/components/Label");
require("./AttributesTableRow.scss");
var atoms_1 = require("../atoms");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
var atoms_2 = require("../../EditorCore/atoms");
var organisms_1 = require("../organisms");
var AttributesTableRow = function (props) {
    var modelIndex = props.modelIndex, characteristicIndex = props.characteristicIndex, characteristic = props.characteristic, attributeIndex = props.attributeIndex, attribute = props.attribute, areReasonCodesUsed = props.areReasonCodesUsed, characteristicReasonCode = props.characteristicReasonCode, dataFields = props.dataFields, miningFields = props.miningFields, onEdit = props.onEdit, onDelete = props.onDelete, onCommit = props.onCommit;
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var validations = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)()
            .forModel(modelIndex)
            .forCharacteristics()
            .forCharacteristic(characteristicIndex)
            .forAttribute(attributeIndex)
            .forPredicate()
            .build());
    }, [modelIndex, characteristicIndex, attributeIndex, attribute, miningFields]);
    var handleEdit = function (event) {
        event.preventDefault();
        event.stopPropagation();
        onEdit();
    };
    return ((0, jsx_runtime_1.jsx)("article", __assign({ id: "attribute-n".concat(attributeIndex), "data-testid": "attribute-n".concat(attributeIndex), className: "attribute-item", onClick: function () { return onEdit(); }, onKeyDown: function (e) {
            if (e.key === "Enter") {
                handleEdit(e);
            }
        }, "data-ouia-component-type": "attribute-item", tabIndex: 0 }, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true, style: { height: "100%" } }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [validations.length > 0 && ((0, jsx_runtime_1.jsx)(atoms_2.ValidationIndicatorLabel, __assign({ validations: validations, cssClass: "characteristic-list__item__label" }, { children: (0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [attribute.predicate && (0, jsx_runtime_1.jsx)("pre", { children: (0, organisms_1.toText)(attribute.predicate, dataFields) }), !attribute.predicate && ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)("strong", { children: "Predicate:" }), "\u00A0", (0, jsx_runtime_1.jsx)("em", { children: "Missing" })] }))] }) }))), validations.length === 0 && ((0, jsx_runtime_1.jsx)(Label_1.Label, __assign({ tabIndex: 0, color: "blue", onClose: function (e) {
                                    e.nativeEvent.stopImmediatePropagation();
                                    e.stopPropagation();
                                    onCommit({ predicate: undefined });
                                } }, { children: (0, jsx_runtime_1.jsx)("pre", { children: (0, organisms_1.toText)(attribute.predicate, dataFields) }) })))] }) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ isFilled: true }, { children: (0, jsx_runtime_1.jsx)(atoms_1.AttributeLabels, { modelIndex: modelIndex, characteristicIndex: characteristicIndex, characteristic: characteristic, activeAttributeIndex: attributeIndex, activeAttribute: attribute, areReasonCodesUsed: areReasonCodesUsed, characteristicReasonCode: characteristicReasonCode, commit: onCommit }) })), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(atoms_1.AttributesTableAction, { index: attributeIndex, onDelete: onDelete }) })] })) })));
};
exports.AttributesTableRow = AttributesTableRow;
//# sourceMappingURL=AttributesTableRow.js.map