"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelCard = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var Tooltip_1 = require("@patternfly/react-core/dist/js/components/Tooltip");
var Card_1 = require("@patternfly/react-core/dist/js/components/Card");
var react_1 = require("react");
require("./ModelCard.scss");
var atoms_1 = require("../atoms");
var atoms_2 = require("../../EditorCore/atoms");
var ModelCard = function (props) {
    var index = props.index, modelName = props.modelName, modelType = props.modelType;
    var onClickModel = (0, react_1.useCallback)(function (e) {
        if (index !== undefined) {
            e.stopPropagation();
            props.onClick(index);
        }
    }, [index]);
    var onDeleteModel = (0, react_1.useCallback)(function (e) {
        if (index !== undefined) {
            e.stopPropagation();
            props.onDelete(index);
        }
    }, [index]);
    var _modelName = (0, react_1.useMemo)(function () { return (modelName === "" ? atoms_2.MODEL_NAME_NOT_SET : modelName); }, [modelName]);
    return ((0, jsx_runtime_1.jsxs)(Card_1.Card, __assign({ "data-testid": "model-card", isHoverable: true, className: "model-card", onClick: onClickModel }, { children: [(0, jsx_runtime_1.jsx)(Card_1.CardHeader, { children: (0, jsx_runtime_1.jsx)(Card_1.CardHeaderMain, { children: (0, jsx_runtime_1.jsx)(atoms_1.ModelCardIcon, { type: modelType }) }) }), (0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ content: (0, jsx_runtime_1.jsx)("div", { children: _modelName }) }, { children: (0, jsx_runtime_1.jsx)(Card_1.CardTitle, __assign({ className: "model-card__title" }, { children: (0, jsx_runtime_1.jsx)("span", __assign({ "data-testid": "model-card__title" }, { children: _modelName })) })) })), " ", (0, jsx_runtime_1.jsx)(Card_1.CardBody, { children: (0, jsx_runtime_1.jsx)("div", __assign({ "data-testid": "model-card__model-type" }, { children: modelType })) }), (0, jsx_runtime_1.jsx)(Card_1.CardFooter, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ "data-testid": "model-card__delete", variant: "primary", onClick: onDeleteModel }, { children: "Delete" })) })] })));
};
exports.ModelCard = ModelCard;
//# sourceMappingURL=ModelCard.js.map