"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Scopes = void 0;
var ScopeImpl_1 = require("./ScopeImpl");
var ReservedWords_1 = require("../ReservedWords");
var FunctionSymbol_1 = require("./FunctionSymbol");
var Scopes = (function () {
    function Scopes() {
        var _this = this;
        this.builtInScope = new ScopeImpl_1.ScopeImpl("<builtin>");
        this.globalScope = new ScopeImpl_1.ScopeImpl("<global>", this.builtInScope);
        ReservedWords_1.ReservedWords.FeelFunctions.forEach(function (word) {
            _this.globalScope.define(new FunctionSymbol_1.FunctionSymbol(word));
        });
    }
    Scopes.prototype.getBuiltInScope = function () {
        return this.builtInScope;
    };
    Scopes.prototype.getGlobalScope = function () {
        return this.builtInScope.getChildScopes().get("<global>");
    };
    return Scopes;
}());
exports.Scopes = Scopes;
//# sourceMappingURL=Scopes.js.map