var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from "react";
import { Children, cloneElement, isValidElement } from "react";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { OutlinedQuestionCircleIcon } from "@patternfly/react-icons/dist/js/icons/outlined-question-circle-icon";
import { connectField, filterDOMProps } from "uniforms";
import ListItemField from "./ListItemField";
import ListAddField from "./ListAddField";
filterDOMProps.register("minCount", "wrapperCol", "labelCol");
function ListField(_a) {
    var { children = React.createElement(ListItemField, { name: "$" }), error, errorMessage, info, initialCount, itemProps, label, name, value, showInlineError } = _a, props = __rest(_a, ["children", "error", "errorMessage", "info", "initialCount", "itemProps", "label", "name", "value", "showInlineError"]);
    return (React.createElement("div", Object.assign({ "data-testid": "list-field" }, filterDOMProps(props)),
        React.createElement(Split, { hasGutter: true },
            React.createElement(SplitItem, null, label && (React.createElement("label", null,
                label,
                !!info && (React.createElement("span", null,
                    "\u00A0",
                    React.createElement(Tooltip, { content: info },
                        React.createElement(OutlinedQuestionCircleIcon, null))))))),
            React.createElement(SplitItem, { isFilled: true }),
            React.createElement(SplitItem, null,
                React.createElement(ListAddField, { name: "$", initialCount: initialCount }))),
        React.createElement("div", null, value === null || value === void 0 ? void 0 : value.map((item, itemIndex) => Children.map(children, (child, childIndex) => {
            var _a;
            return isValidElement(child)
                ? cloneElement(child, Object.assign({ key: `${itemIndex}-${childIndex}`, name: (_a = child.props.name) === null || _a === void 0 ? void 0 : _a.split(/\$(.*)/s).slice(0, -1).join(`${itemIndex}`) }, itemProps))
                : child;
        })))));
}
export default connectField(ListField);
//# sourceMappingURL=ListField.js.map