import _ from "lodash";
const createSearchTextArray = (taskNames) => {
    const formattedTextArray = [];
    taskNames.forEach((word) => {
        formattedTextArray.push({
            referenceName: {
                like: `*${word}*`,
            },
        });
    });
    return {
        or: formattedTextArray,
    };
};
const createUserAssignmentClause = (currentUser) => {
    return {
        or: [
            { actualOwner: { equal: currentUser.id } },
            {
                and: [
                    { actualOwner: { isNull: true } },
                    {
                        not: { excludedUsers: { contains: currentUser.id } },
                    },
                    {
                        or: [
                            { potentialUsers: { contains: currentUser.id } },
                            { potentialGroups: { containsAny: currentUser.groups } },
                        ],
                    },
                ],
            },
        ],
    };
};
export const buildTaskInboxWhereArgument = (currentUser, activeFilters) => {
    if (activeFilters) {
        const filtersClause = [];
        if (activeFilters.taskStates.length > 0) {
            filtersClause.push({
                state: { in: activeFilters.taskStates },
            });
        }
        if (activeFilters.taskNames.length > 0) {
            filtersClause.push(createSearchTextArray(activeFilters.taskNames));
        }
        if (filtersClause.length > 0) {
            return {
                and: [
                    createUserAssignmentClause(currentUser),
                    {
                        and: filtersClause,
                    },
                ],
            };
        }
    }
    return createUserAssignmentClause(currentUser);
};
export const getOrderByObject = (sortBy) => {
    if (!_.isEmpty(sortBy)) {
        return _.set({}, sortBy.property, sortBy.direction.toUpperCase());
    }
    return {
        lastUpdate: "DESC",
    };
};
//# sourceMappingURL=QueryUtils.js.map