import { ResourceContent, ResourceContentOptions, ResourceListOptions, ResourcesList } from "@kie-tools-core/workspace/dist/api";
import * as React from "react";
import { WorkspaceDescriptor } from "../worker/api/WorkspaceDescriptor";
import { BitbucketOrigin, GistOrigin, GitHubOrigin, SnippetOrigin } from "../worker/api/WorkspaceOrigin";
import { LocalFile } from "../worker/api/LocalFile";
import { WorkspacesSharedWorker } from "../worker/WorkspacesSharedWorker";
import { GitServerRef } from "../worker/api/GitServerRef";
import { FetchResult } from "isomorphic-git";
import { UnstagedModifiedFilesStatusEntryType } from "../services/GitService";
export declare class WorkspaceFile {
    private readonly args;
    private readonly parsedRelativePath;
    constructor(args: {
        workspaceId: string;
        relativePath: string;
        getFileContents: () => Promise<Uint8Array>;
    });
    get getFileContentsAsString(): () => Promise<string>;
    get getFileContents(): () => Promise<Uint8Array>;
    get workspaceId(): string;
    get relativePath(): string;
    get relativePathWithoutExtension(): string;
    get relativeDirPath(): string;
    get extension(): string;
    get nameWithoutExtension(): string;
    get name(): string;
}
export interface WorkspacesContextType {
    workspacesSharedWorker: WorkspacesSharedWorker;
    getUniqueFileIdentifier(args: {
        workspaceId: string;
        relativePath: string;
    }): Promise<string>;
    createWorkspaceFromLocal: (args: {
        localFiles: LocalFile[];
        preferredName?: string;
        gitAuthSessionId?: string;
    }) => Promise<{
        workspace: WorkspaceDescriptor;
        suggestedFirstFile?: WorkspaceFile;
    }>;
    createWorkspaceFromGitRepository: (args: {
        origin: GistOrigin | GitHubOrigin | BitbucketOrigin | SnippetOrigin;
        gitConfig?: {
            email: string;
            name: string;
        };
        gitAuthSessionId: string | undefined;
        authInfo?: {
            username: string;
            password: string;
        };
        insecurelyDisableTlsCertificateValidation?: boolean;
    }) => Promise<{
        workspace: WorkspaceDescriptor;
        suggestedFirstFile?: WorkspaceFile;
    }>;
    pull(args: {
        workspaceId: string;
        gitConfig?: {
            email: string;
            name: string;
        };
        authInfo?: {
            username: string;
            password: string;
        };
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<void>;
    push(args: {
        workspaceId: string;
        ref: string;
        remoteRef?: string;
        remote: string;
        force: boolean;
        authInfo: {
            username: string;
            password: string;
        };
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<void>;
    deleteBranch(args: {
        workspaceId: string;
        ref: string;
    }): Promise<void>;
    branch(args: {
        workspaceId: string;
        name: string;
        checkout: boolean;
    }): Promise<void>;
    checkout(args: {
        workspaceId: string;
        ref: string;
        remote: string;
    }): Promise<void>;
    checkoutFilesFromLocalHead(args: {
        workspaceId: string;
        ref?: string;
        filepaths?: string[];
    }): Promise<void>;
    addRemote(args: {
        workspaceId: string;
        name: string;
        url: string;
        force: boolean;
    }): Promise<void>;
    deleteRemote(args: {
        workspaceId: string;
        name: string;
    }): Promise<void>;
    resolveRef(args: {
        workspaceId: string;
        ref: string;
    }): Promise<string>;
    getGitServerRefs(args: {
        url: string;
        authInfo?: {
            username: string;
            password: string;
        };
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<GitServerRef[]>;
    hasLocalChanges(args: {
        workspaceId: string;
    }): Promise<boolean>;
    getUnstagedModifiedFilesStatus(args: {
        workspaceId: string;
    }): Promise<UnstagedModifiedFilesStatusEntryType[]>;
    isFileModified(args: {
        workspaceId: string;
        relativePath: string;
    }): Promise<boolean>;
    commit(args: {
        workspaceId: string;
        targetBranch: string;
        gitConfig?: {
            email: string;
            name: string;
        };
        commitMessage: string;
    }): Promise<void>;
    createSavePoint(args: {
        workspaceId: string;
        gitConfig?: {
            email: string;
            name: string;
        };
        commitMessage?: string;
        forceHasChanges?: boolean;
    }): Promise<void>;
    stageFile: (args: {
        workspaceId: string;
        relativePath: string;
    }) => Promise<void>;
    fetch(args: {
        workspaceId: string;
        remote: string;
        ref: string;
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<FetchResult>;
    addEmptyFile(args: {
        workspaceId: string;
        destinationDirRelativePath: string;
        extension: string;
    }): Promise<WorkspaceFile>;
    prepareZip(args: {
        workspaceId: string;
        onlyExtensions?: string[];
        globPattern?: string;
    }): Promise<Blob>;
    getFiles(args: {
        workspaceId: string;
        globPattern?: string;
    }): Promise<WorkspaceFile[]>;
    deleteWorkspace(args: {
        workspaceId: string;
    }): Promise<void>;
    renameWorkspace(args: {
        workspaceId: string;
        newName: string;
    }): Promise<void>;
    resourceContentList(args: {
        workspaceId: string;
        globPattern: string;
        opts?: ResourceListOptions;
    }): Promise<ResourcesList>;
    resourceContentGet(args: {
        workspaceId: string;
        relativePath: string;
        opts?: ResourceContentOptions;
    }): Promise<ResourceContent | undefined>;
    getFile(args: {
        workspaceId: string;
        relativePath: string;
    }): Promise<WorkspaceFile | undefined>;
    getFileContent(args: {
        workspaceId: string;
        relativePath: string;
    }): Promise<Uint8Array>;
    renameFile(args: {
        file: WorkspaceFile;
        newFileNameWithoutExtension: string;
    }): Promise<WorkspaceFile>;
    updateFile(args: {
        workspaceId: string;
        relativePath: string;
        newContent: string;
    }): Promise<void>;
    deleteFile(args: {
        file: WorkspaceFile;
    }): Promise<void>;
    moveFile(args: {
        file: WorkspaceFile;
        newDirPath: string;
    }): Promise<WorkspaceFile>;
    addFile(args: {
        workspaceId: string;
        name: string;
        destinationDirRelativePath: string;
        content: string;
        extension: string;
    }): Promise<WorkspaceFile>;
    existsFile(args: {
        workspaceId: string;
        relativePath: string;
    }): Promise<boolean>;
    listAllWorkspaces(): Promise<WorkspaceDescriptor[]>;
    getWorkspace(args: {
        workspaceId: string;
    }): Promise<WorkspaceDescriptor>;
    initGitOnWorkspace(args: {
        workspaceId: string;
        remoteUrl: URL;
        branch?: string;
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<void>;
    initGistOnWorkspace(args: {
        workspaceId: string;
        remoteUrl: URL;
        branch: string;
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<void>;
    initSnippetOnWorkspace(args: {
        workspaceId: string;
        remoteUrl: URL;
        branch: string;
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<void>;
    changeGitAuthSessionId(args: {
        workspaceId: string;
        gitAuthSessionId: string | undefined;
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<void>;
    initLocalOnWorkspace(args: {
        workspaceId: string;
    }): Promise<void>;
}
export declare const WorkspacesContext: React.Context<WorkspacesContextType>;
export declare function useWorkspaces(): WorkspacesContextType;
//# sourceMappingURL=WorkspacesContext.d.ts.map