import { ResourceListOptions, ResourcesList, ResourceContentOptions, ResourceContent } from "@kie-tools-core/workspace/dist/api";
import { UnstagedModifiedFilesStatusEntryType } from "../services/GitService";
import { GitServerRef } from "./api/GitServerRef";
import { LocalFile } from "./api/LocalFile";
import { WorkspaceDescriptor } from "./api/WorkspaceDescriptor";
import { BitbucketOrigin, GistOrigin, GitHubOrigin, SnippetOrigin } from "./api/WorkspaceOrigin";
import { WorkspacesWorkerApi } from "./api/WorkspacesWorkerApi";
import { WorkspaceWorkerFile } from "./api/WorkspaceWorkerFile";
import { WorkspaceWorkerFileDescriptor } from "./api/WorkspaceWorkerFileDescriptor";
import { WorkspaceServices } from "./createWorkspaceServices";
import { FetchResult } from "isomorphic-git";
export interface FileFilter {
    isModel: (path: string) => boolean;
    isEditable: (path: string) => boolean;
    isSupported: (path: string) => boolean;
}
export declare class WorkspacesWorkerApiImpl implements WorkspacesWorkerApi {
    private readonly args;
    private readonly MAX_NEW_FILE_INDEX_ATTEMPTS;
    private readonly NEW_FILE_DEFAULT_NAME;
    private readonly GIT_DEFAULT_USER;
    constructor(args: {
        appName: string;
        fileFilter: FileFilter;
        services: WorkspaceServices;
    });
    kieSandboxWorkspacesGit_changeGitAuthSessionId(args: {
        workspaceId: string;
        gitAuthSessionId: string | undefined;
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<void>;
    kieSandboxWorkspacesGit_initGistOnExistingWorkspace(args: {
        workspaceId: string;
        remoteUrl: string;
        branch: string;
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<void>;
    kieSandboxWorkspacesGit_initSnippetOnExistingWorkspace(args: {
        workspaceId: string;
        remoteUrl: string;
        branch: string;
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<void>;
    kieSandboxWorkspacesGit_initGitOnExistingWorkspace(args: {
        workspaceId: string;
        remoteUrl: string;
        branch?: string;
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<void>;
    kieSandboxWorkspacesGit_initLocalOnExistingWorkspace(args: {
        workspaceId: string;
    }): Promise<void>;
    kieSandboxWorkspacesStorage_getWorkspace(args: {
        workspaceId: string;
    }): Promise<WorkspaceDescriptor>;
    kieSandboxWorkspacesStorage_listAllWorkspaces(): Promise<WorkspaceDescriptor[]>;
    kieSandboxWorkspacesStorage_resourceContentGet(args: {
        workspaceId: string;
        relativePath: string;
        opts?: ResourceContentOptions;
    }): Promise<ResourceContent | undefined>;
    kieSandboxWorkspacesStorage_resourceContentList(args: {
        workspaceId: string;
        globPattern: string;
        opts?: ResourceListOptions;
    }): Promise<ResourcesList>;
    kieSandboxWorkspacesStorage_addEmptyFile(args: {
        workspaceId: string;
        destinationDirRelativePath: string;
        extension: string;
    }): Promise<WorkspaceWorkerFileDescriptor>;
    kieSandboxWorkspacesStorage_addFile(args: {
        workspaceId: string;
        name: string;
        destinationDirRelativePath: string;
        content: string;
        extension: string;
    }): Promise<WorkspaceWorkerFile>;
    kieSandboxWorkspacesStorage_deleteFile(args: {
        wwfd: WorkspaceWorkerFileDescriptor;
    }): Promise<void>;
    kieSandboxWorkspacesStorage_moveFile(args: {
        wwfd: WorkspaceWorkerFileDescriptor;
        newDirPath: string;
    }): Promise<WorkspaceWorkerFileDescriptor>;
    kieSandboxWorkspacesStorage_deleteWorkspace(args: {
        workspaceId: string;
    }): Promise<void>;
    kieSandboxWorkspacesStorage_existsFile(args: {
        workspaceId: string;
        relativePath: string;
    }): Promise<boolean>;
    kieSandboxWorkspacesStorage_getFile(args: {
        workspaceId: string;
        relativePath: string;
    }): Promise<WorkspaceWorkerFileDescriptor | undefined>;
    kieSandboxWorkspacesStorage_getFileContent(args: {
        workspaceId: string;
        relativePath: string;
    }): Promise<Uint8Array>;
    kieSandboxWorkspacesStorage_getFiles(args: {
        workspaceId: string;
        globPattern?: string;
    }): Promise<WorkspaceWorkerFileDescriptor[]>;
    kieSandboxWorkspacesStorage_getUniqueFileIdentifier(args: {
        workspaceId: string;
        relativePath: string;
    }): Promise<string>;
    kieSandboxWorkspacesStorage_prepareZip(args: {
        workspaceId: string;
        onlyExtensions?: string[];
        globPattern?: string;
    }): Promise<Blob>;
    kieSandboxWorkspacesStorage_renameFile(args: {
        wwfd: WorkspaceWorkerFileDescriptor;
        newFileNameWithoutExtension: string;
    }): Promise<WorkspaceWorkerFileDescriptor>;
    kieSandboxWorkspacesStorage_renameWorkspace(args: {
        workspaceId: string;
        newName: string;
    }): Promise<void>;
    kieSandboxWorkspacesStorage_updateFile(args: {
        wwfd: WorkspaceWorkerFileDescriptor;
        newContent: string;
    }): Promise<void>;
    kieSandboxWorkspacesGit_addRemote(args: {
        workspaceId: string;
        name: string;
        url: string;
        force: boolean;
    }): Promise<void>;
    kieSandboxWorkspacesGit_deleteRemote(args: {
        workspaceId: string;
        name: string;
    }): Promise<void>;
    kieSandboxWorkspacesGit_branch(args: {
        workspaceId: string;
        name: string;
        checkout: boolean;
    }): Promise<void>;
    kieSandboxWorkspacesGit_checkout(args: {
        workspaceId: string;
        ref: string;
        remote: string;
    }): Promise<void>;
    kieSandboxWorkspacesGit_checkoutFilesFromLocalHead(args: {
        workspaceId: string;
        ref?: string;
        filepaths: string[];
    }): Promise<void>;
    kieSandboxWorkspacesGit_getGitServerRefs(args: {
        url: string;
        authInfo?: {
            username: string;
            password: string;
        };
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<GitServerRef[]>;
    kieSandboxWorkspacesGit_clone(args: {
        origin: GistOrigin | GitHubOrigin | BitbucketOrigin | SnippetOrigin;
        gitConfig?: {
            email: string;
            name: string;
        };
        authInfo?: {
            username: string;
            password: string;
        };
        gitAuthSessionId: string | undefined;
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<{
        workspace: WorkspaceDescriptor;
        suggestedFirstFile?: WorkspaceWorkerFileDescriptor;
    }>;
    kieSandboxWorkspacesGit_getUnstagedModifiedFilesStatus(args: {
        workspaceId: string;
    }): Promise<UnstagedModifiedFilesStatusEntryType[]>;
    kieSandboxWorkspacesGit_stageFile(args: {
        workspaceId: string;
        relativePath: string;
    }): Promise<void>;
    kieSandboxWorkspacesGit_commit(args: {
        workspaceId: string;
        gitConfig?: {
            email: string;
            name: string;
        };
        commitMessage: string;
        targetBranch: string;
    }): Promise<void>;
    kieSandboxWorkspacesGit_createSavePoint(args: {
        workspaceId: string;
        gitConfig?: {
            email: string;
            name: string;
        };
        commitMessage?: string;
    }): Promise<void>;
    kieSandboxWorkspacesGit_fetch(args: {
        workspaceId: string;
        remote: string;
        ref: string;
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<FetchResult>;
    kieSandboxWorkspacesGit_init(args: {
        localFiles: LocalFile[];
        preferredName?: string;
        gitAuthSessionId: string | undefined;
        gitConfig?: {
            email: string;
            name: string;
        };
        gitInsecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<{
        workspace: WorkspaceDescriptor;
        suggestedFirstFile?: WorkspaceWorkerFileDescriptor;
    }>;
    kieSandboxWorkspacesGit_pull(args: {
        workspaceId: string;
        gitConfig?: {
            email: string;
            name: string;
        };
        authInfo?: {
            username: string;
            password: string;
        };
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<void>;
    kieSandboxWorkspacesGit_push(args: {
        workspaceId: string;
        ref: string;
        remoteRef?: string;
        remote: string;
        force: boolean;
        authInfo: {
            username: string;
            password: string;
        };
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<void>;
    kieSandboxWorkspacesGit_deleteBranch(args: {
        workspaceId: string;
        ref: string;
    }): Promise<void>;
    kieSandboxWorkspacesGit_resolveRef(args: {
        workspaceId: string;
        ref: string;
    }): Promise<string>;
    kieSandboxWorkspacesGit_isModified(args: {
        workspaceId: string;
        relativePath: string;
    }): Promise<boolean>;
    kieSandboxWorkspacesGit_hasLocalChanges(args: {
        workspaceId: string;
    }): Promise<boolean>;
    kieSandboxWorkspacesStorage_flushes(): {
        defaultValue: never[];
    };
    private createWorkspace;
}
//# sourceMappingURL=WorkspacesWorkerApiImpl.d.ts.map