var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { JSON_SCHEMA_INPUT_SET_PATH, RECURSION_KEYWORD, RECURSION_REF_KEYWORD } from "./jsonSchemaConstants";
import { DmnAjvSchemaFormat } from "./ajv";
import { resolveRefs, pathFromPtr } from "json-refs";
import cloneDeep from "lodash/cloneDeep";
import getObjectValueByPath from "lodash/get";
import setObjectValueByPath from "lodash/set";
import unsetObjectValueByPath from "lodash/unset";
import { X_DMN_TYPE_KEYWORD } from "./jitExecutorKeywords";
function getFieldDefaultValue(dmnField) {
    if ((dmnField === null || dmnField === void 0 ? void 0 : dmnField.type) === "string" && (dmnField === null || dmnField === void 0 ? void 0 : dmnField.format) === undefined) {
        return undefined;
    }
    if ((dmnField === null || dmnField === void 0 ? void 0 : dmnField.type) === "number") {
        return undefined;
    }
    if ((dmnField === null || dmnField === void 0 ? void 0 : dmnField.type) === "boolean") {
        return false;
    }
    if ((dmnField === null || dmnField === void 0 ? void 0 : dmnField.type) === "array") {
        return [];
    }
    if ((dmnField === null || dmnField === void 0 ? void 0 : dmnField.type) === "object") {
        return {};
    }
    return undefined;
}
export function getDefaultValues(jsonSchema) {
    var _a, _b;
    return (_b = Object.entries((_a = getObjectValueByPath(jsonSchema, JSON_SCHEMA_INPUT_SET_PATH)) !== null && _a !== void 0 ? _a : {})) === null || _b === void 0 ? void 0 : _b.reduce((acc, [key, field]) => {
        acc[key] = getFieldDefaultValue(field);
        return acc;
    }, {});
}
export function removeChangedPropertiesAndAdditionalProperties(validator, toValidate) {
    const validation = validator(toValidate);
    if (!validation && validator.errors) {
        validator.errors.forEach((error) => {
            var _a;
            if (error.keyword !== "type" && error.keyword !== "format") {
                return;
            }
            if (error.keyword === "type" &&
                ((_a = error.parentSchema) === null || _a === void 0 ? void 0 : _a.format) === DmnAjvSchemaFormat.DATE_TIME &&
                error.data instanceof Date) {
                return;
            }
            const pathList = error.dataPath
                .replace(/\['([^']+)'\]/g, "$1")
                .replace(/\[(\d+)\]/g, ".$1")
                .split(".")
                .filter((e) => e !== "");
            const path = pathList.length === 1 ? pathList[0] : pathList.slice(0, -1).join(".");
            unsetObjectValueByPath(toValidate, path);
        });
    }
}
export function dereferenceAndCheckForRecursion(formSchema, canceled) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const formSchemaCopy = cloneDeep(formSchema);
            const $ref = getObjectValueByPath(formSchemaCopy, "$ref");
            unsetObjectValueByPath(formSchemaCopy, "$ref");
            const { refs, resolved } = yield resolveRefs(formSchemaCopy);
            if (canceled === null || canceled === void 0 ? void 0 : canceled.get()) {
                return;
            }
            let reResolve = false;
            Object.entries(refs).forEach(([ptr, properties]) => {
                if (properties === null || properties === void 0 ? void 0 : properties.circular) {
                    const path = pathFromPtr(ptr);
                    const recursiveRefPath = pathFromPtr(properties.def.$ref);
                    setObjectValueByPath(resolved, path.join("."), {
                        [`${RECURSION_KEYWORD}`]: true,
                        [`${RECURSION_REF_KEYWORD}`]: properties.def.$ref,
                        [`${X_DMN_TYPE_KEYWORD}`]: recursiveRefPath[recursiveRefPath.length - 1],
                    });
                    reResolve = true;
                }
            });
            if (reResolve) {
                const { resolved: reResolved } = yield resolveRefs(resolved);
                if (canceled === null || canceled === void 0 ? void 0 : canceled.get()) {
                    return;
                }
                if ($ref) {
                    setObjectValueByPath(reResolved, "$ref", $ref);
                }
                return reResolved;
            }
            if ($ref) {
                setObjectValueByPath(resolved, "$ref", $ref);
            }
            return resolved;
        }
        catch (err) {
            console.log(err);
            return;
        }
    });
}
//# sourceMappingURL=jsonSchema.js.map