"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var selenium_webdriver_1 = require("selenium-webdriver");
var Editor_1 = require("../Editor");
var SwfEditor = (function (_super) {
    __extends(SwfEditor, _super);
    function SwfEditor() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SwfEditor.prototype.isTextEditorPresent = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.tools.by(SwfEditor.TEXT_EDITOR_LOCATOR).wait(1000).isPresent()];
                    case 1: return [2, _a.sent()];
                }
            });
        });
    };
    SwfEditor.prototype.isDiagramEditorPresent = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.tools.by(SwfEditor.DIAGRAM_EDITOR_LOCATOR).wait(1000).isPresent()];
                    case 1: return [2, _a.sent()];
                }
            });
        });
    };
    SwfEditor.prototype.isTextEditorKeyboardShortcutsIconPresent = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.isKeyboardShortcutsIconPresent(SwfEditor.TEXT_EDITOR_LOCATOR)];
                    case 1: return [2, _a.sent()];
                }
            });
        });
    };
    SwfEditor.prototype.isDiagramEditorKeyboardShortcutsIconPresent = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.isKeyboardShortcutsIconPresent(SwfEditor.DIAGRAM_EDITOR_LOCATOR)];
                    case 1: return [2, _a.sent()];
                }
            });
        });
    };
    SwfEditor.prototype.getTextEditorContent = function () {
        return __awaiter(this, void 0, void 0, function () {
            var textEditor, content;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.enterIFrame(SwfEditor.TEXT_EDITOR_LOCATOR)];
                    case 1:
                        _a.sent();
                        return [4, this.tools.by(SwfEditor.EDITOR_TEXTAREA_LOCATOR).getElement()];
                    case 2:
                        textEditor = _a.sent();
                        return [4, textEditor.getAttribute("value")];
                    case 3:
                        content = _a.sent();
                        return [4, this.leaveIFrame()];
                    case 4:
                        _a.sent();
                        return [2, content];
                }
            });
        });
    };
    SwfEditor.prototype.enterIFrame = function (iframeBy) {
        return __awaiter(this, void 0, void 0, function () {
            var iFrame;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.tools.by(iframeBy).getElement()];
                    case 1:
                        iFrame = _a.sent();
                        return [4, iFrame.enterFrame()];
                    case 2:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    SwfEditor.prototype.leaveIFrame = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.tools.window().leaveFrame()];
                    case 1:
                        _a.sent();
                        return [4, this.enter()];
                    case 2:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    SwfEditor.prototype.isKeyboardShortcutsIconPresent = function (iFrameBy) {
        return __awaiter(this, void 0, void 0, function () {
            var isPresent;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.enterIFrame(iFrameBy)];
                    case 1:
                        _a.sent();
                        return [4, this.tools.by(SwfEditor.KEYBOARD_SHORTCUTS_ICON_LOCATOR).wait(1000).isPresent()];
                    case 2:
                        isPresent = _a.sent();
                        return [4, this.leaveIFrame()];
                    case 3:
                        _a.sent();
                        return [2, isPresent];
                }
            });
        });
    };
    SwfEditor.DIAGRAM_EDITOR_LOCATOR = selenium_webdriver_1.By.xpath("//iframe[contains(@src, 'serverless-workflow-diagram-editor-envelope.html')]");
    SwfEditor.EDITOR_TEXTAREA_LOCATOR = selenium_webdriver_1.By.xpath("//div[contains(@class, 'monaco-editor')]//textarea");
    SwfEditor.KEYBOARD_SHORTCUTS_ICON_LOCATOR = selenium_webdriver_1.By.xpath("//div[@data-ouia-component-id='keyboard-shortcuts-icon']");
    SwfEditor.TEXT_EDITOR_LOCATOR = selenium_webdriver_1.By.xpath("//iframe[contains(@src, 'serverless-workflow-text-editor-envelope.html')]");
    return SwfEditor;
}(Editor_1.default));
exports.default = SwfEditor;
//# sourceMappingURL=SwfEditor.js.map