import { jsx as _jsx } from "react/jsx-runtime";
import { NestedExpressionDispatchContextProvider, useBoxedExpressionEditorDispatch, } from "../../BoxedExpressionEditorContext";
import { useCallback } from "react";
import { ExpressionContainer } from "../ExpressionDefinitionRoot/ExpressionContainer";
export function ConditionalExpressionCell({ data, rowIndex, columnIndex, parentElementId, }) {
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const onSetExpression = useCallback(({ getNewExpression }) => {
        setExpression((prev) => {
            if (rowIndex === 0) {
                const ret = Object.assign(Object.assign({}, prev), { if: Object.assign(Object.assign({}, prev.if), { expression: getNewExpression(prev.if.expression) }) });
                return ret;
            }
            else if (rowIndex === 1) {
                const ret = Object.assign(Object.assign({}, prev), { then: Object.assign(Object.assign({}, prev.then), { expression: getNewExpression(prev.then.expression) }) });
                return ret;
            }
            else if (rowIndex === 2) {
                const ret = Object.assign(Object.assign({}, prev), { else: Object.assign(Object.assign({}, prev.else), { expression: getNewExpression(prev.else.expression) }) });
                return ret;
            }
            else {
                throw new Error("ConditionalExpression shouldn't have more than 3 rows.");
            }
        });
    }, [rowIndex, setExpression]);
    return (_jsx(NestedExpressionDispatchContextProvider, Object.assign({ onSetExpression: onSetExpression }, { children: _jsx(ExpressionContainer, { expression: data[rowIndex].part.expression, isResetSupported: true, isNested: true, rowIndex: rowIndex, columnIndex: columnIndex, parentElementId: parentElementId, parentElementTypeRef: undefined }) })));
}
//# sourceMappingURL=ConditionalExpressionCell.js.map