"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPropertiesRecursively = exports.parseJsonSchema = void 0;
var api_1 = require("../../../../api");
var convertSource_1 = require("../convertSource");
function parseJsonSchema(args, jsonSchemaDocument) {
    var _a, _b;
    return {
        name: (_a = jsonSchemaDocument.title) !== null && _a !== void 0 ? _a : args.serviceFileName,
        type: "jsonschema",
        source: args.source,
        functions: [
            {
                source: (0, convertSource_1.convertSource)(args.source),
                arguments: getPropertiesRecursively(jsonSchemaDocument),
                type: "jsonschema",
                name: (_b = jsonSchemaDocument.title) !== null && _b !== void 0 ? _b : args.serviceFileName,
            },
        ],
        rawContent: args.serviceFileContent,
    };
}
exports.parseJsonSchema = parseJsonSchema;
function getPropertiesRecursively(schema) {
    var _a;
    var result = {};
    function recursiveFunc(subSchema, tempArray) {
        var schemaType = subSchema.type;
        if (schemaType == api_1.SwfServiceCatalogFunctionArgumentType.array) {
            recursiveFunc(subSchema.items, tempArray);
        }
        else if (schemaType == api_1.SwfServiceCatalogFunctionArgumentType.object) {
            Object.entries(subSchema.properties).forEach(function (_a) {
                var _b = __read(_a, 2), propertyName = _b[0], propertyValue = _b[1];
                result[propertyName] = resolveArgumentType(propertyValue["type"]);
                recursiveFunc(propertyValue, tempArray);
            });
        }
        else {
            return;
        }
        return tempArray;
    }
    return (_a = recursiveFunc(schema, result)) !== null && _a !== void 0 ? _a : {};
}
exports.getPropertiesRecursively = getPropertiesRecursively;
function resolveArgumentType(type) {
    return api_1.SwfServiceCatalogFunctionArgumentType[type];
}
//# sourceMappingURL=jsonschema.js.map