/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.yard.validator.key;


import java.util.Objects;

public class ColumnKey implements KeyParent, Comparable<KeyParent> {

    private final String column;

    public ColumnKey(final String column) {
        this.column = column;
    }

    @Override
    public String toString() {
        return column;
    }

    @Override
    public int compareTo(final KeyParent o) {
        if (o instanceof ColumnKey) {
            return column.compareTo(((ColumnKey) o).column);
        } else {
            return -1;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ColumnKey columnKey = (ColumnKey) o;
        return Objects.equals(column, columnKey.column);
    }

    @Override
    public int hashCode() {
        return Objects.hash(column);
    }
}
