/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft;

import com.alipay.remoting.serialization.Serializer;
import com.alipay.remoting.serialization.SerializerManager;
import com.alipay.sofa.jraft.CliService;
import com.alipay.sofa.jraft.Lifecycle;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.NodeOptions;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.rpc.CliClientService;
import com.alipay.sofa.jraft.rpc.RaftRpcServerFactory;
import com.alipay.sofa.jraft.rpc.RpcProcessor;
import com.alipay.sofa.jraft.rpc.RpcServer;
import com.alipay.sofa.jraft.util.Endpoint;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.seata.common.XID;
import org.apache.seata.common.store.SessionMode;
import org.apache.seata.common.util.NetUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.serializer.SerializerType;
import org.apache.seata.discovery.registry.FileRegistryServiceImpl;
import org.apache.seata.discovery.registry.MultiRegistryFactory;
import org.apache.seata.discovery.registry.RegistryService;
import org.apache.seata.discovery.registry.namingserver.NamingserverRegistryServiceImpl;
import org.apache.seata.server.cluster.raft.RaftServer;
import org.apache.seata.server.cluster.raft.RaftServerManager;
import org.apache.seata.server.cluster.raft.RaftStateMachine;
import org.apache.seata.server.cluster.raft.processor.PutNodeInfoRequestProcessor;
import org.apache.seata.server.cluster.raft.serializer.JacksonBoltSerializer;
import org.apache.seata.server.store.StoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RaftServerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftServerManager.class);
    private static final Map<String, RaftServer> RAFT_SERVER_MAP = new HashMap();
    private static final AtomicBoolean INIT = new AtomicBoolean(false);
    private static final org.apache.seata.config.Configuration CONFIG = ConfigurationFactory.getInstance();
    private static volatile boolean RAFT_MODE;
    private static RpcServer rpcServer;

    public static CliService getCliServiceInstance() {
        return SingletonHandler.access$000();
    }

    public static CliClientService getCliClientServiceInstance() {
        return SingletonHandler.access$100();
    }

    public static void init() {
        if (INIT.compareAndSet(false, true)) {
            String initConfStr = CONFIG.getConfig("server.raft.serverAddr");
            RAFT_MODE = StoreConfig.getSessionMode().equals((Object)SessionMode.RAFT);
            if (StringUtils.isBlank((String)initConfStr)) {
                if (RAFT_MODE) {
                    throw new IllegalArgumentException("Raft store mode must config: server.raft.serverAddr");
                }
                return;
            }
            if (RAFT_MODE) {
                for (RegistryService instance : MultiRegistryFactory.getInstances()) {
                    if (instance instanceof FileRegistryServiceImpl || instance instanceof NamingserverRegistryServiceImpl) continue;
                    throw new IllegalArgumentException("Raft store mode not support other Registration Center");
                }
            }
            LOGGER.warn("raft mode and raft cluster is an experimental feature");
            Configuration initConf = new Configuration();
            if (!initConf.parse(initConfStr)) {
                throw new IllegalArgumentException("fail to parse initConf:" + initConfStr);
            }
            int port = Integer.parseInt(System.getProperty("server.raftPort", "0"));
            PeerId serverId = null;
            String host = XID.getIpAddress();
            if (port <= 0) {
                block3: for (PeerId peer : initConf.getPeers()) {
                    List peerIps = NetUtil.getHostByName((String)peer.getIp());
                    for (String peerIp : peerIps) {
                        if (!StringUtils.equals((String)peerIp, (String)host)) continue;
                        if (serverId != null) {
                            throw new IllegalArgumentException("server.raft.cluster has duplicate ip, For local debugging, use -Dserver.raftPort to specify the raft port");
                        }
                        serverId = peer;
                        continue block3;
                    }
                }
            } else {
                serverId = new PeerId(host, port);
            }
            String dataPath = CONFIG.getConfig("store.file.dir", "sessionStore") + File.separator + "raft" + File.separator + serverId.getPort();
            String group = CONFIG.getConfig("server.raft.group", "default");
            try {
                rpcServer = RaftRpcServerFactory.createRaftRpcServer((Endpoint)serverId.getEndpoint());
                RaftServer raftServer = new RaftServer(dataPath, group, serverId, RaftServerManager.initNodeOptions((Configuration)initConf), rpcServer);
                RAFT_SERVER_MAP.put(group, raftServer);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("fail init raft cluster:" + e.getMessage(), e);
            }
        }
    }

    public static void start() {
        RAFT_SERVER_MAP.forEach((group, raftServer) -> {
            try {
                raftServer.start();
            }
            catch (IOException e) {
                LOGGER.error("start seata server raft cluster error, group: {} ", group, (Object)e);
                throw new RuntimeException(e);
            }
            LOGGER.info("started seata server raft cluster, group: {} ", group);
        });
        if (rpcServer != null) {
            rpcServer.registerProcessor((RpcProcessor)new PutNodeInfoRequestProcessor());
            SerializerManager.addSerializer((int)SerializerType.JACKSON.getCode(), (Serializer)new JacksonBoltSerializer());
            if (!rpcServer.init(null)) {
                throw new RuntimeException("start raft node fail!");
            }
        }
    }

    public static void destroy() {
        RAFT_SERVER_MAP.forEach((group, raftServer) -> {
            raftServer.close();
            LOGGER.info("closed seata server raft cluster, group: {} ", group);
        });
        Optional.ofNullable(rpcServer).ifPresent(Lifecycle::shutdown);
        RAFT_SERVER_MAP.clear();
        rpcServer = null;
        RAFT_MODE = false;
        INIT.set(false);
    }

    public static RaftServer getRaftServer(String group) {
        return (RaftServer)RAFT_SERVER_MAP.get(group);
    }

    public static Collection<RaftServer> getRaftServers() {
        return RAFT_SERVER_MAP.values();
    }

    public static boolean isLeader(String group) {
        AtomicReference stateMachine = new AtomicReference();
        Optional.ofNullable(RAFT_SERVER_MAP.get(group)).ifPresent(raftServer -> stateMachine.set(raftServer.getRaftStateMachine()));
        RaftStateMachine raftStateMachine = (RaftStateMachine)stateMachine.get();
        return !RaftServerManager.isRaftMode() && RAFT_SERVER_MAP.isEmpty() || raftStateMachine != null && raftStateMachine.isLeader();
    }

    public static boolean isRaftMode() {
        return RAFT_MODE;
    }

    private static RaftOptions initRaftOptions() {
        RaftOptions raftOptions = new RaftOptions();
        raftOptions.setApplyBatch(CONFIG.getInt("server.raft.applyBatch", raftOptions.getApplyBatch()));
        raftOptions.setMaxAppendBufferSize(CONFIG.getInt("server.raft.maxAppendBufferSize", raftOptions.getMaxAppendBufferSize()));
        raftOptions.setDisruptorBufferSize(CONFIG.getInt("server.raft.disruptorBufferSize", raftOptions.getDisruptorBufferSize()));
        raftOptions.setMaxReplicatorInflightMsgs(CONFIG.getInt("server.raft.maxReplicatorInflightMsgs", raftOptions.getMaxReplicatorInflightMsgs()));
        raftOptions.setSync(CONFIG.getBoolean("server.raft.sync", raftOptions.isSync()));
        return raftOptions;
    }

    private static NodeOptions initNodeOptions(Configuration initConf) {
        NodeOptions nodeOptions = new NodeOptions();
        nodeOptions.setDisableCli(false);
        int snapshotInterval = CONFIG.getInt("server.raft.snapshotInterval", 600);
        nodeOptions.setSnapshotIntervalSecs(snapshotInterval);
        nodeOptions.setRaftOptions(RaftServerManager.initRaftOptions());
        nodeOptions.setElectionTimeoutMs(CONFIG.getInt("server.raft.electionTimeoutMs", 1000));
        nodeOptions.setInitialConf(initConf);
        return nodeOptions;
    }

    public static Set<String> groups() {
        return RAFT_SERVER_MAP.keySet();
    }
}

