/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.binaryallocator.ema;

public class AdaptiveWeightedAverage {
    private static final int OLD_THRESHOLD = 100;
    private float average;
    private int sampleCount;
    private int tmpMaxSample;
    private final int weight;
    private boolean isOld;

    public AdaptiveWeightedAverage(int weight) {
        this.weight = weight;
        this.average = 0.0f;
        this.sampleCount = 0;
        this.tmpMaxSample = 0;
    }

    public void sample(int newSample) {
        this.tmpMaxSample = Math.max(this.tmpMaxSample, newSample);
    }

    public void update() {
        this.incrementCount();
        int newSample = this.tmpMaxSample;
        this.tmpMaxSample = 0;
        this.average = this.computeAdaptiveAverage(newSample, this.average);
    }

    public float average() {
        return this.average;
    }

    public void clear() {
        this.average = 0.0f;
        this.sampleCount = 0;
        this.tmpMaxSample = 0;
        this.isOld = false;
    }

    void incrementCount() {
        ++this.sampleCount;
        if (!this.isOld && this.sampleCount > 100) {
            this.isOld = true;
        }
    }

    float computeAdaptiveAverage(int newSample, float average) {
        int countWeight = 0;
        if (!this.isOld) {
            countWeight = 100 / this.sampleCount;
        }
        int adaptiveWeight = Math.max(this.weight, countWeight);
        return (100.0f - (float)adaptiveWeight) * average / 100.0f + (float)(adaptiveWeight * newSample) / 100.0f;
    }
}

