/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.recover.file;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileResourceUtils;
import org.apache.tsfile.exception.NotCompatibleTsFileException;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTsFileRecoverPerformer
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTsFileRecoverPerformer.class);
    protected final TsFileResource tsFileResource;
    protected RestorableTsFileIOWriter writer;

    protected AbstractTsFileRecoverPerformer(TsFileResource tsFileResource) {
        this.tsFileResource = tsFileResource;
    }

    protected void recoverWithWriter() throws DataRegionException, IOException {
        File tsFile = this.tsFileResource.getTsFile();
        File chunkMetadataTempFile = new File(tsFile.getAbsolutePath() + ".meta");
        if (chunkMetadataTempFile.exists()) {
            FileUtils.delete((File)chunkMetadataTempFile);
        }
        if (this.tsFileResource.resourceFileExists()) {
            this.loadResourceFile();
            return;
        }
        if (!tsFile.exists()) {
            logger.error("TsFile {} is missing, will skip its recovery.", (Object)tsFile);
            return;
        }
        try {
            this.writer = new RestorableTsFileIOWriter(tsFile);
        }
        catch (NotCompatibleTsFileException e) {
            boolean result = tsFile.delete();
            logger.warn("TsFile {} is incompatible. Try to delete it and delete result is {}", (Object)tsFile, (Object)result);
            throw new DataRegionException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new DataRegionException(e);
        }
        if (!this.writer.hasCrashed()) {
            try {
                this.reconstructResourceFile();
            }
            catch (IOException e) {
                throw new DataRegionException("Failed recover the resource file: " + tsFile + ".resource" + e);
            }
        }
    }

    private void loadResourceFile() throws IOException {
        try {
            this.tsFileResource.deserialize();
        }
        catch (Throwable e) {
            logger.warn("Cannot deserialize .resource file of {}, try to reconstruct it.", (Object)this.tsFileResource.getTsFile(), (Object)e);
            this.reconstructResourceFile();
        }
    }

    protected void reconstructResourceFile() throws IOException {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(this.tsFileResource.getTsFile().getAbsolutePath());){
            TsFileResourceUtils.updateTsFileResource(reader, this.tsFileResource);
        }
        PipeDataNodeAgent.runtime().assignProgressIndexForTsFileRecovery(this.tsFileResource);
        this.tsFileResource.serialize();
    }

    public boolean hasCrashed() {
        return this.writer != null && this.writer.hasCrashed();
    }

    public boolean canWrite() {
        return this.writer != null && this.writer.canWrite();
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }
}

