/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class MonitoredItemModifyRequest
extends Structure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=755");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=757");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=756");
    private final UInteger monitoredItemId;
    private final MonitoringParameters requestedParameters;

    public MonitoredItemModifyRequest(UInteger monitoredItemId, MonitoringParameters requestedParameters) {
        this.monitoredItemId = monitoredItemId;
        this.requestedParameters = requestedParameters;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public UInteger getMonitoredItemId() {
        return this.monitoredItemId;
    }

    public MonitoringParameters getRequestedParameters() {
        return this.requestedParameters;
    }

    protected MonitoredItemModifyRequest(MonitoredItemModifyRequestBuilder<?, ?> b) {
        super(b);
        this.monitoredItemId = ((MonitoredItemModifyRequestBuilder)b).monitoredItemId;
        this.requestedParameters = ((MonitoredItemModifyRequestBuilder)b).requestedParameters;
    }

    public static MonitoredItemModifyRequestBuilder<?, ?> builder() {
        return new MonitoredItemModifyRequestBuilderImpl();
    }

    public MonitoredItemModifyRequestBuilder<?, ?> toBuilder() {
        return new MonitoredItemModifyRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitoredItemModifyRequest)) {
            return false;
        }
        MonitoredItemModifyRequest other = (MonitoredItemModifyRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UInteger this$monitoredItemId = this.getMonitoredItemId();
        UInteger other$monitoredItemId = other.getMonitoredItemId();
        if (this$monitoredItemId == null ? other$monitoredItemId != null : !((Object)this$monitoredItemId).equals(other$monitoredItemId)) {
            return false;
        }
        MonitoringParameters this$requestedParameters = this.getRequestedParameters();
        MonitoringParameters other$requestedParameters = other.getRequestedParameters();
        return !(this$requestedParameters == null ? other$requestedParameters != null : !((Object)this$requestedParameters).equals(other$requestedParameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MonitoredItemModifyRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UInteger $monitoredItemId = this.getMonitoredItemId();
        result = result * 59 + ($monitoredItemId == null ? 43 : ((Object)$monitoredItemId).hashCode());
        MonitoringParameters $requestedParameters = this.getRequestedParameters();
        result = result * 59 + ($requestedParameters == null ? 43 : ((Object)$requestedParameters).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MonitoredItemModifyRequest(monitoredItemId=" + this.getMonitoredItemId() + ", requestedParameters=" + this.getRequestedParameters() + ")";
    }

    private static final class MonitoredItemModifyRequestBuilderImpl
    extends MonitoredItemModifyRequestBuilder<MonitoredItemModifyRequest, MonitoredItemModifyRequestBuilderImpl> {
        private MonitoredItemModifyRequestBuilderImpl() {
        }

        @Override
        protected MonitoredItemModifyRequestBuilderImpl self() {
            return this;
        }

        @Override
        public MonitoredItemModifyRequest build() {
            return new MonitoredItemModifyRequest(this);
        }
    }

    public static abstract class MonitoredItemModifyRequestBuilder<C extends MonitoredItemModifyRequest, B extends MonitoredItemModifyRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private UInteger monitoredItemId;
        private MonitoringParameters requestedParameters;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MonitoredItemModifyRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(MonitoredItemModifyRequest instance, MonitoredItemModifyRequestBuilder<?, ?> b) {
            b.monitoredItemId(instance.monitoredItemId);
            b.requestedParameters(instance.requestedParameters);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B monitoredItemId(UInteger monitoredItemId) {
            this.monitoredItemId = monitoredItemId;
            return (B)this.self();
        }

        public B requestedParameters(MonitoringParameters requestedParameters) {
            this.requestedParameters = requestedParameters;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "MonitoredItemModifyRequest.MonitoredItemModifyRequestBuilder(super=" + super.toString() + ", monitoredItemId=" + this.monitoredItemId + ", requestedParameters=" + this.requestedParameters + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<MonitoredItemModifyRequest> {
        @Override
        public Class<MonitoredItemModifyRequest> getType() {
            return MonitoredItemModifyRequest.class;
        }

        @Override
        public MonitoredItemModifyRequest decode(SerializationContext context, UaDecoder decoder) {
            UInteger monitoredItemId = decoder.readUInt32("MonitoredItemId");
            MonitoringParameters requestedParameters = (MonitoringParameters)decoder.readStruct("RequestedParameters", MonitoringParameters.TYPE_ID);
            return new MonitoredItemModifyRequest(monitoredItemId, requestedParameters);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, MonitoredItemModifyRequest value) {
            encoder.writeUInt32("MonitoredItemId", value.getMonitoredItemId());
            encoder.writeStruct("RequestedParameters", (Object)value.getRequestedParameters(), MonitoringParameters.TYPE_ID);
        }
    }
}

