/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.rpc;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.handlers.rpc.DataNodeAsyncRequestRPCHandler;
import org.apache.iotdb.mpp.rpc.thrift.TDeviceViewResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeDeviceViewFieldDetectionHandler
extends DataNodeAsyncRequestRPCHandler<TDeviceViewResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TreeDeviceViewFieldDetectionHandler.class);

    protected TreeDeviceViewFieldDetectionHandler(CnToDnAsyncRequestType requestType, int requestId, TDataNodeLocation targetNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, Map<Integer, TDeviceViewResp> integerTDeviceViewRespMap, CountDownLatch countDownLatch) {
        super(requestType, requestId, targetNode, dataNodeLocationMap, integerTDeviceViewRespMap, countDownLatch);
    }

    public void onComplete(TDeviceViewResp response) {
        this.responseMap.put(this.requestId, response);
        if (response.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.info("Successfully {} on DataNode: {}", this.requestType, (Object)this.formattedTargetLocation);
        } else {
            LOGGER.error("Failed to {} on DataNode: {}, response: {}", new Object[]{this.requestType, this.formattedTargetLocation, response});
        }
        this.nodeLocationMap.remove(this.requestId);
        this.countDownLatch.countDown();
    }

    public void onError(Exception e) {
        String errorMsg = "Failed to " + this.requestType + " on DataNode: " + this.formattedTargetLocation + ", exception: " + e.getMessage();
        LOGGER.warn(errorMsg, (Throwable)e);
        this.responseMap.put(this.requestId, new TDeviceViewResp().setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)errorMsg)).setDeviewViewFieldTypeMap(new HashMap()));
        this.countDownLatch.countDown();
    }
}

