/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.detector;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.iotdb.confignode.manager.load.cache.AbstractHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.IFailureDetector;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionHeartbeatSample;
import org.apache.tsfile.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhiAccrualDetector
implements IFailureDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhiAccrualDetector.class);
    private final long threshold;
    private final long acceptableHeartbeatPauseNs;
    private final long minHeartbeatStdNs;
    private final int codeStartSampleCount;
    private final IFailureDetector fallbackDuringColdStart;
    private final Cache<Object, Boolean> availibilityCache;

    public PhiAccrualDetector(long threshold, long acceptableHeartbeatPauseNs, long minHeartbeatStdNs, int minimalSampleCount, IFailureDetector fallbackDuringColdStart) {
        this.threshold = threshold;
        this.acceptableHeartbeatPauseNs = acceptableHeartbeatPauseNs;
        this.minHeartbeatStdNs = minHeartbeatStdNs;
        this.codeStartSampleCount = minimalSampleCount;
        this.fallbackDuringColdStart = fallbackDuringColdStart;
        this.availibilityCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    }

    @Override
    public boolean isAvailable(Object id, List<AbstractHeartbeatSample> history) {
        if (history.size() < this.codeStartSampleCount) {
            return this.fallbackDuringColdStart.isAvailable(id, history);
        }
        PhiAccrual phiAccrual = this.create(history);
        boolean isAvailable = phiAccrual.phi() < (double)this.threshold;
        Boolean previousAvailability = (Boolean)this.availibilityCache.getIfPresent(id);
        this.availibilityCache.put(id, (Object)isAvailable);
        if (Boolean.TRUE.equals(previousAvailability) && !isAvailable) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (double interval : phiAccrual.heartbeatIntervals) {
                long msInterval = (long)interval / 1000000L;
                builder.append(msInterval).append(", ");
            }
            builder.append(phiAccrual.timeElapsedSinceLastHeartbeat / 1000000L);
            builder.append("]");
            LOGGER.info(String.format("Node %s Down, heartbeat history (ms): %s", id, builder));
        }
        return isAvailable;
    }

    PhiAccrual create(List<AbstractHeartbeatSample> history) {
        ArrayList<Double> heartbeatIntervals = new ArrayList<Double>();
        long lastTs = -1L;
        for (AbstractHeartbeatSample sample : history) {
            Preconditions.checkArgument((sample instanceof NodeHeartbeatSample || sample instanceof RegionHeartbeatSample ? 1 : 0) != 0);
            if (lastTs == -1L) {
                lastTs = sample.getSampleLogicalTimestamp();
                continue;
            }
            heartbeatIntervals.add((double)sample.getSampleLogicalTimestamp() - (double)lastTs);
            lastTs = sample.getSampleLogicalTimestamp();
        }
        long lastHeartbeatTimestamp = history.get(history.size() - 1).getSampleLogicalTimestamp();
        long timeElapsedSinceLastHeartbeat = System.nanoTime() - lastHeartbeatTimestamp;
        double[] intervalArray = heartbeatIntervals.stream().mapToDouble(Double::doubleValue).toArray();
        return new PhiAccrual(intervalArray, timeElapsedSinceLastHeartbeat, this.minHeartbeatStdNs, this.acceptableHeartbeatPauseNs);
    }

    static final class PhiAccrual {
        private final double[] heartbeatIntervals;
        private final long timeElapsedSinceLastHeartbeat;
        private final long minHeartbeatStd;
        private final long acceptableHeartbeatPause;

        PhiAccrual(double[] heartbeatIntervals, long timeElapsedSinceLastHeartbeat, long minHeartbeatStd, long acceptableHeartbeatPause) {
            Preconditions.checkArgument((heartbeatIntervals.length > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((timeElapsedSinceLastHeartbeat >= 0L ? 1 : 0) != 0);
            this.heartbeatIntervals = heartbeatIntervals;
            this.timeElapsedSinceLastHeartbeat = timeElapsedSinceLastHeartbeat;
            this.minHeartbeatStd = minHeartbeatStd;
            this.acceptableHeartbeatPause = acceptableHeartbeatPause;
        }

        double phi() {
            DescriptiveStatistics ds = new DescriptiveStatistics(this.heartbeatIntervals);
            double mean = ds.getMean();
            double std = ds.getStandardDeviation();
            std = Math.max(std, (double)this.minHeartbeatStd);
            return this.p(this.timeElapsedSinceLastHeartbeat, mean += (double)this.acceptableHeartbeatPause, std);
        }

        private double p(double elapsedTime, double historyMean, double historyStd) {
            double y = (elapsedTime - historyMean) / historyStd;
            double e = Math.exp(-y * (1.5976 + 0.070566 * y * y));
            if (elapsedTime > historyMean) {
                return -Math.log10(e / (1.0 + e));
            }
            return -Math.log10(1.0 - 1.0 / (1.0 + e));
        }
    }
}

