/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TransactionSpecificationRequestControl
extends Control {
    @NotNull
    public static final String TRANSACTION_SPECIFICATION_REQUEST_OID = "1.3.6.1.1.21.2";
    private static final long serialVersionUID = 6489819774149849092L;
    @NotNull
    private final ASN1OctetString transactionID;

    public TransactionSpecificationRequestControl(@NotNull ASN1OctetString transactionID) {
        super(TRANSACTION_SPECIFICATION_REQUEST_OID, true, new ASN1OctetString(transactionID.getValue()));
        Validator.ensureNotNull(transactionID);
        this.transactionID = transactionID;
    }

    public TransactionSpecificationRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        this.transactionID = control.getValue();
        if (this.transactionID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_TXN_REQUEST_CONTROL_NO_VALUE.get());
        }
    }

    @NotNull
    public ASN1OctetString getTransactionID() {
        return this.transactionID;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_TXN_SPECIFICATION_REQUEST.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("TransactionSpecificationRequestControl(transactionID='");
        buffer.append(this.transactionID.stringValue());
        buffer.append("')");
    }
}

